/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.LookaheadStream;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.prism.Marker;
import io.jenkins.plugins.prism.Sanitizer;
import io.jenkins.plugins.util.JenkinsFacade;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import j2html.tags.UnescapedText;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;

class SourcePrinter {
    private static final Sanitizer SANITIZER = new Sanitizer();
    private static final ColumnMarker COLUMN_MARKER = new ColumnMarker("-n/a-");
    private static final String LINE_NUMBERS = "line-numbers";
    private static final String MATCH_BRACES = "match-braces";
    private static final String ICON_MD = "icon-md";
    private final JenkinsFacade jenkinsFacade;

    SourcePrinter() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    SourcePrinter(JenkinsFacade jenkinsFacade) {
        this.jenkinsFacade = jenkinsFacade;
    }

    public String render(String fileName, Stream<String> lines, Marker marker) {
        try (LookaheadStream stream = new LookaheadStream(lines);){
            int start = marker.getLineStart();
            int end = marker.getLineEnd();
            StringBuilder before = this.readBlockUntilLine(stream, start - 1);
            StringBuilder marked = this.readBlockUntilLine(stream, end);
            StringBuilder after = this.readBlockUntilLine(stream, Integer.MAX_VALUE);
            String language = this.selectLanguageClass(fileName);
            String code = this.asCode(before, language, LINE_NUMBERS, MATCH_BRACES) + this.asMarkedCode(marked, marker, language, LINE_NUMBERS, "highlight", MATCH_BRACES) + this.createInfoPanel(marker) + this.asCode(after, language, LINE_NUMBERS, MATCH_BRACES);
            String string = TagCreator.pre().with((DomContent)new UnescapedText(code)).renderFormatted();
            return string;
        }
    }

    private StringBuilder readBlockUntilLine(LookaheadStream stream, int end) {
        StringBuilder marked = new StringBuilder();
        while (stream.hasNext() && stream.getLine() < end) {
            marked.append(stream.next());
            marked.append("\n");
        }
        return marked;
    }

    private String createInfoPanel(Marker marker) {
        return ((ContainerTag)this.createBox(marker).withClass("analysis-warning")).render();
    }

    private ContainerTag createBox(Marker marker) {
        if (StringUtils.isEmpty((CharSequence)marker.getDescription())) {
            return this.createTitle(marker, false);
        }
        return this.createTitleAndCollapsedDescription(marker, marker.getDescription());
    }

    private DomContent createIcon(String name) {
        if (name.startsWith("symbol")) {
            String symbol = Symbol.get((SymbolRequest)new SymbolRequest.Builder().withRaw(name).withClasses(ICON_MD).build());
            return new UnescapedText(symbol);
        }
        return ((EmptyTag)TagCreator.img().withSrc(this.jenkinsFacade.getImagePath(name))).withClasses(new String[]{ICON_MD});
    }

    private ContainerTag createTitle(Marker marker, boolean isCollapseVisible) {
        return TagCreator.div().with((DomContent)((ContainerTag)TagCreator.table().withClass("analysis-title")).with((DomContent)TagCreator.tr().with(new DomContent[]{TagCreator.td().with(this.createIcon(marker.getIcon())), ((ContainerTag)TagCreator.td().withClass("analysis-title-column")).with((DomContent)((ContainerTag)TagCreator.div().withClass("analysis-warning-title")).with((DomContent)this.replaceNewLine(marker.getTitle()))), this.createCollapseButton(isCollapseVisible)})));
    }

    private ContainerTag createCollapseButton(boolean isCollapseVisible) {
        ContainerTag td = TagCreator.td();
        if (isCollapseVisible) {
            td.with((DomContent)new UnescapedText(this.jenkinsFacade.getSymbol(new SymbolRequest.Builder().withName("chevron-down-circle-outline").withPluginName("ionicons-api").withClasses("analysis-collapse-icon").build())));
        }
        return td;
    }

    private ContainerTag createTitleAndCollapsedDescription(Marker marker, String description) {
        return TagCreator.div().with(new DomContent[]{((ContainerTag)TagCreator.div().withClass("analysis-collapse-button")).with((DomContent)this.createTitle(marker, true)), ((ContainerTag)TagCreator.div().withClasses(new String[]{"collapse", "analysis-detail"})).with((DomContent)this.unescape(description)).withId("analysis-description")});
    }

    private UnescapedText replaceNewLine(String message) {
        return this.unescape(message.replace("\n", "<br>"));
    }

    private UnescapedText unescape(String message) {
        return new UnescapedText(SANITIZER.render(message));
    }

    private String selectLanguageClass(String fileName) {
        switch (StringUtils.substringAfterLast((String)fileName, (String)".")) {
            case "htm": 
            case "html": 
            case "xml": 
            case "xsd": {
                return "language-markup";
            }
            case "css": {
                return "language-css";
            }
            case "js": {
                return "language-javascript";
            }
            case "c": {
                return "language-c";
            }
            case "cs": {
                return "language-csharp";
            }
            case "cpp": {
                return "language-cpp";
            }
            case "Dockerfile": {
                return "language-docker";
            }
            case "go": {
                return "language-go";
            }
            case "groovy": {
                return "language-groovy";
            }
            case "json": {
                return "language-json";
            }
            case "md": {
                return "language-markdown";
            }
            case "erb": 
            case "jsp": 
            case "tag": {
                return "language-erb";
            }
            case "jav": 
            case "java": {
                return "language-java";
            }
            case "rb": {
                return "language-ruby";
            }
            case "kt": {
                return "language-kotlin";
            }
            case "vb": {
                return "language-vbnet";
            }
            case "pl": {
                return "language-perl";
            }
            case "php": {
                return "language-php";
            }
            case "py": {
                return "language-python";
            }
            case "sql": {
                return "language-sql";
            }
            case "scala": 
            case "sc": {
                return "language-scala";
            }
            case "swift": {
                return "language-swift";
            }
            case "ts": {
                return "language-typescript";
            }
            case "yaml": {
                return "language-yaml";
            }
        }
        return "language-clike";
    }

    private String asMarkedCode(StringBuilder text, Marker marker, String ... classes) {
        StringBuilder marked = marker.getLineStart() == marker.getLineEnd() ? COLUMN_MARKER.markColumns(text.toString(), marker.getColumnStart(), marker.getColumnEnd()) : text;
        String sanitized = SANITIZER.render(StringEscapeUtils.escapeHtml4((String)marked.toString()));
        String markerReplaced = COLUMN_MARKER.replacePlaceHolderWithHtmlTag(sanitized);
        return ((ContainerTag)TagCreator.code().withClasses(classes)).with((DomContent)new UnescapedText(markerReplaced)).render();
    }

    private String asCode(StringBuilder text, String ... classes) {
        return ((ContainerTag)TagCreator.code().withClasses(classes)).with((DomContent)this.unescape(StringEscapeUtils.escapeHtml4((String)text.toString()))).render();
    }

    static final class ColumnMarker {
        private static final String OPENING_TAG = "<span class='code-mark'>";
        private static final String CLOSING_TAG = "</span>";
        private final String openingTagPlaceHolder;
        private final String closingTagPlaceHolder;

        ColumnMarker(String placeHolderText) {
            this.openingTagPlaceHolder = "OpEn" + placeHolderText;
            this.closingTagPlaceHolder = "ClOsE" + placeHolderText;
        }

        public StringBuilder markColumns(String text, int start, int end) {
            int realEnd;
            if (start < 1 || text.length() == 0 || end > text.length()) {
                return new StringBuilder(text);
            }
            int realStart = start - 1;
            int n = realEnd = end == 0 ? text.length() - 1 : end - 1;
            if (realStart > realEnd) {
                return new StringBuilder(text);
            }
            int afterMark = realEnd + 1;
            String before = text.substring(0, realStart);
            String toBeMarked = text.substring(realStart, afterMark);
            String after = text.substring(afterMark);
            return new StringBuilder(before).append(this.openingTagPlaceHolder).append(toBeMarked).append(this.closingTagPlaceHolder).append(after);
        }

        public String replacePlaceHolderWithHtmlTag(String text) {
            return text.replaceAll(this.openingTagPlaceHolder, OPENING_TAG).replaceAll(this.closingTagPlaceHolder, CLOSING_TAG);
        }
    }
}

