/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.postgresql;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import io.jenkins.plugins.postgresql.PostgreSQLFingerprintStorage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import jenkins.fingerprints.FingerprintStorage;
import org.flywaydb.core.Flyway;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DatabaseSchemaLoader {
    private static final Logger LOGGER = Logger.getLogger(DatabaseSchemaLoader.class.getName());
    static boolean MIGRATED;

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
    public static void migrateSchema() {
        FingerprintStorage configuration = FingerprintStorage.get();
        if (configuration instanceof PostgreSQLFingerprintStorage) {
            try {
                PostgreSQLFingerprintStorage storage = (PostgreSQLFingerprintStorage)configuration;
                DataSource dataSource = storage.getConnectionSupplier().database().getDataSource();
                Database database = GlobalDatabaseConfiguration.get().getDatabase();
                assert (database != null);
                Flyway flyway = Flyway.configure((ClassLoader)DatabaseSchemaLoader.class.getClassLoader()).baselineOnMigrate(true).table("fingerprint_flyway_schema_history").dataSource(dataSource).locations(new String[]{"db/migration/postgres"}).load();
                flyway.migrate();
                MIGRATED = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error migrating database, correct this error before using the fingerprint plugin", e);
            }
        }
    }
}

