/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.postgresql;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.TaskListener;
import io.jenkins.plugins.postgresql.DatabaseSchemaLoader;
import io.jenkins.plugins.postgresql.PostgreSQLFingerprintStorageDescriptor;
import io.jenkins.plugins.postgresql.Queries;
import io.jenkins.plugins.postgresql.XStreamHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.fingerprints.FingerprintStorage;
import jenkins.model.FingerprintFacet;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class PostgreSQLFingerprintStorage
extends FingerprintStorage {
    private final String instanceId = Util.getDigestOf((InputStream)new ByteArrayInputStream(InstanceIdentity.get().getPublic().getEncoded()));
    private static final Logger LOGGER = Logger.getLogger(PostgreSQLFingerprintStorage.class.getName());
    private transient ConnectionSupplier connectionSupplier;

    public static PostgreSQLFingerprintStorage get() {
        return (PostgreSQLFingerprintStorage)((Object)ExtensionList.lookupSingleton(PostgreSQLFingerprintStorage.class));
    }

    @DataBoundConstructor
    public PostgreSQLFingerprintStorage() throws IOException {
    }

    public ConnectionSupplier getConnectionSupplier() {
        if (this.connectionSupplier == null) {
            this.connectionSupplier = new LocalConnectionSupplier();
        }
        return this.connectionSupplier;
    }

    public synchronized void save(@NonNull Fingerprint fingerprint) throws IOException {
        try (Connection connection = this.getConnectionSupplier().connection();){
            connection.setAutoCommit(false);
            this.delete(fingerprint.getHashString(), connection);
            try (PreparedStatement preparedStatement = connection.prepareStatement(Queries.getQuery("insert_fingerprint"));){
                preparedStatement.setString(1, fingerprint.getHashString());
                preparedStatement.setString(2, this.instanceId);
                preparedStatement.setTimestamp(3, new Timestamp(fingerprint.getTimestamp().getTime()));
                preparedStatement.setString(4, fingerprint.getFileName());
                Fingerprint.BuildPtr original = fingerprint.getOriginal();
                if (original != null) {
                    preparedStatement.setString(5, original.getName());
                    preparedStatement.setInt(6, original.getNumber());
                } else {
                    preparedStatement.setNull(5, 0);
                    preparedStatement.setNull(6, 0);
                }
                preparedStatement.executeUpdate();
            }
            Hashtable usages = fingerprint.getUsages();
            if (usages != null) {
                for (Map.Entry entry : usages.entrySet()) {
                    String jobName = (String)entry.getKey();
                    Fingerprint.RangeSet rangeSet = (Fingerprint.RangeSet)entry.getValue();
                    Iterator iterator = rangeSet.listNumbers().iterator();
                    while (iterator.hasNext()) {
                        int buildNumber = (Integer)iterator.next();
                        PreparedStatement preparedStatement = connection.prepareStatement(Queries.getQuery("insert_fingerprint_job_build_relation"));
                        try {
                            preparedStatement.setString(1, fingerprint.getHashString());
                            preparedStatement.setString(2, this.instanceId);
                            preparedStatement.setString(3, jobName);
                            preparedStatement.setInt(4, buildNumber);
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            preparedStatement.close();
                        }
                    }
                }
            }
            for (FingerprintFacet fingerprintFacet : fingerprint.getPersistedFacets()) {
                JSONObject fingerprintFacetJSON = new JSONObject(XStreamHandler.getXStream().toXML((Object)fingerprintFacet));
                String fingerprintFacetName = (String)fingerprintFacetJSON.keys().next();
                String fingerprintFacetEntry = fingerprintFacetJSON.getJSONObject(fingerprintFacetName).toString();
                PreparedStatement preparedStatement = connection.prepareStatement(Queries.getQuery("insert_fingerprint_facet_relation"));
                try {
                    preparedStatement.setString(1, fingerprint.getHashString());
                    preparedStatement.setString(2, this.instanceId);
                    preparedStatement.setString(3, fingerprintFacetName);
                    preparedStatement.setString(4, fingerprintFacetEntry);
                    preparedStatement.setBoolean(5, fingerprintFacet.isFingerprintDeletionBlocked());
                    preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "PostgreSQL failed in saving fingerprint: " + fingerprint.toString(), e);
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @CheckForNull
    public Fingerprint load(@NonNull String id) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void delete(@NonNull String id) throws IOException {
        try (Connection connection = this.getConnectionSupplier().connection();){
            connection.setAutoCommit(false);
            this.delete(id, connection);
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "PostgreSQL failed in deleting fingerprint: " + id, e);
            throw new IOException(e);
        }
    }

    private void delete(@NonNull String id, @NonNull Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(Queries.getQuery("delete_fingerprint"));){
            preparedStatement.setString(1, id);
            preparedStatement.setString(2, this.instanceId);
            preparedStatement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReady() {
        try (Connection connection = this.getConnectionSupplier().connection();
             PreparedStatement preparedStatement = connection.prepareStatement(Queries.getQuery("select_fingerprint_exists_for_instance"));){
            preparedStatement.setString(1, this.instanceId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = resultSet.getBoolean("exists");
                return bl;
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed connecting to PostgreSQL.", e);
        }
        return false;
    }

    public void iterateAndCleanupFingerprints(TaskListener taskListener) {
    }

    static abstract class ConnectionSupplier
    implements AutoCloseable {
        private transient Connection connection;

        ConnectionSupplier() {
        }

        protected abstract Database database();

        protected void initialize(Connection connection) throws SQLException {
        }

        synchronized Connection connection() throws SQLException {
            if (this.connection == null || this.connection.isClosed()) {
                Connection _connection = this.database().getDataSource().getConnection();
                this.initialize(_connection);
                this.connection = _connection;
            }
            return this.connection;
        }

        @Override
        public void close() {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.connection = null;
        }
    }

    static class LocalConnectionSupplier
    extends ConnectionSupplier {
        LocalConnectionSupplier() {
        }

        @Override
        protected Database database() {
            return GlobalDatabaseConfiguration.get().getDatabase();
        }

        @Override
        protected void initialize(Connection connection) throws SQLException {
            if (!DatabaseSchemaLoader.MIGRATED) {
                DatabaseSchemaLoader.migrateSchema();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends PostgreSQLFingerprintStorageDescriptor {
    }
}

