/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.postgresql;

import com.thoughtworks.xstream.converters.basic.DateConverter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Fingerprint;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DataConversion {
    private static final Logger LOGGER = Logger.getLogger(DataConversion.class.getName());
    private static final DateConverter DATE_CONVERTER = new DateConverter();
    static final String FINGERPRINT = "fingerprint";
    static final String RANGES = "ranges";
    static final String RANGE = "range";
    static final String ID = "id";
    static final String TIMESTAMP = "timestamp";
    static final String FILENAME = "fileName";
    static final String MD5SUM = "md5sum";
    static final String FACETS = "facets";
    static final String USAGES = "usages";
    static final String ORIGINAL = "original";
    static final String ORIGINAL_JOB_BUILD_NUMBER = "original_job_build_number";
    static final String ORIGINAL_JOB_NAME = "original_job_name";
    static final String NAME = "name";
    static final String NUMBER = "number";
    static final String STRING = "string";
    static final String ENTRY = "entry";
    static final String JOB = "job";
    static final String BUILD_NUMBER = "build_number";
    static final String FACET_NAME = "facet_name";
    static final String FACET_ENTRY = "facet_entry";
    static final String EMPTY_STRING = "";

    @NonNull
    static String constructFingerprintJSON(@NonNull Map<String, String> fingerprintMetadata, @NonNull Map<String, Fingerprint.RangeSet> usageMetadata, @NonNull JSONArray facets) {
        JSONObject json = new JSONObject();
        JSONObject fingerprint = new JSONObject();
        JSONArray md5sum = new JSONArray();
        JSONArray usages = new JSONArray();
        JSONObject original = null;
        if (fingerprintMetadata.get(ORIGINAL_JOB_BUILD_NUMBER) != null) {
            original = new JSONObject();
            original.put(NAME, (Object)fingerprintMetadata.get(ORIGINAL_JOB_NAME));
            original.put(NUMBER, Integer.parseInt(fingerprintMetadata.get(ORIGINAL_JOB_BUILD_NUMBER)));
        }
        md5sum.put((Object)fingerprintMetadata.get(ID));
        if (facets.length() == 0) {
            facets.put((Object)EMPTY_STRING);
        }
        if (usageMetadata.size() != 0) {
            JSONObject entry = new JSONObject();
            JSONArray entryArray = new JSONArray();
            for (Map.Entry<String, Fingerprint.RangeSet> usage : usageMetadata.entrySet()) {
                JSONObject jobAndBuildNumber = new JSONObject();
                jobAndBuildNumber.put(STRING, (Object)usage.getKey());
                jobAndBuildNumber.put(RANGES, (Object)Fingerprint.RangeSet.ConverterImpl.serialize((Fingerprint.RangeSet)usage.getValue()));
                entryArray.put((Object)jobAndBuildNumber);
            }
            entry.put(ENTRY, (Object)entryArray);
            usages.put((Object)entry);
        } else {
            usages.put((Object)EMPTY_STRING);
        }
        fingerprint.put(TIMESTAMP, (Object)fingerprintMetadata.get(TIMESTAMP));
        fingerprint.put(FILENAME, (Object)fingerprintMetadata.get(FILENAME));
        fingerprint.put(MD5SUM, (Object)md5sum);
        fingerprint.put(FACETS, (Object)facets);
        fingerprint.put(USAGES, (Object)usages);
        fingerprint.put(ORIGINAL, (Object)original);
        json.put(FINGERPRINT, (Object)fingerprint);
        LOGGER.fine("Fingerprint loaded: " + json.toString());
        return json.toString();
    }

    @NonNull
    static Map<String, String> extractFingerprintMetadata(@NonNull String id, Timestamp timestamp, @NonNull String filename, @CheckForNull String originalJobName, @CheckForNull String originalJobBuildNumber) {
        HashMap<String, String> fingerprintMetadata = new HashMap<String, String>();
        fingerprintMetadata.put(TIMESTAMP, DATE_CONVERTER.toString((Object)new Date(timestamp.getTime())));
        fingerprintMetadata.put(FILENAME, filename);
        fingerprintMetadata.put(ID, id);
        fingerprintMetadata.put(ORIGINAL_JOB_NAME, originalJobName);
        fingerprintMetadata.put(ORIGINAL_JOB_BUILD_NUMBER, originalJobBuildNumber);
        return Collections.unmodifiableMap(fingerprintMetadata);
    }

    @NonNull
    static Map<String, Fingerprint.RangeSet> extractUsageMetadata(@CheckForNull String usagesAsJSONString) {
        HashMap<String, Fingerprint.RangeSet> usageMetadata = new HashMap<String, Fingerprint.RangeSet>();
        if (usagesAsJSONString != null) {
            JSONArray usages = new JSONArray(usagesAsJSONString);
            for (int i = 0; i < usages.length(); ++i) {
                JSONObject usage = usages.getJSONObject(i);
                String jobName = usage.getString(JOB);
                int buildNumber = usage.getInt(BUILD_NUMBER);
                if (usageMetadata.containsKey(jobName)) {
                    ((Fingerprint.RangeSet)usageMetadata.get(jobName)).add(buildNumber);
                    continue;
                }
                Fingerprint.RangeSet rangeSet = new Fingerprint.RangeSet();
                rangeSet.add(buildNumber);
                usageMetadata.put(jobName, rangeSet);
            }
        }
        return Collections.unmodifiableMap(usageMetadata);
    }

    @NonNull
    static JSONArray extractFacets(@CheckForNull String facetsAsJSONString) {
        JSONArray facetsArray = new JSONArray();
        JSONObject facetsObject = new JSONObject();
        if (facetsAsJSONString != null) {
            JSONObject facetFromResultSet;
            String facetName;
            JSONArray facetsFromResultSet = new JSONArray(facetsAsJSONString);
            for (int i = 0; i < facetsFromResultSet.length() && !(facetName = (facetFromResultSet = facetsFromResultSet.getJSONObject(i)).getString(FACET_NAME)).equals(EMPTY_STRING); ++i) {
                if (facetsObject.has(facetName)) {
                    facetsObject.getJSONArray(facetName).put((Object)facetFromResultSet.getJSONObject(FACET_ENTRY));
                    continue;
                }
                JSONArray facetEntries = new JSONArray();
                facetEntries.put((Object)facetFromResultSet.getJSONObject(FACET_ENTRY));
                facetsObject.put(facetName, (Object)facetEntries);
            }
        }
        facetsArray.put((Object)facetsObject);
        return facetsArray;
    }
}

