CREATE TABLE FINGERPRINT 
  (FINGERPRINT_ID              VARCHAR(256)   NOT NULL,
   INSTANCE_ID                 CHAR(32)       NOT NULL,
   TIMESTAMP                   TIMESTAMP      NOT NULL,
   FILENAME                    VARCHAR(256)   NOT NULL,
   ORIGINAL_JOB_NAME           VARCHAR(256)           ,
   ORIGINAL_JOB_BUILD_NUMBER   INT                    ,
   PRIMARY KEY(FINGERPRINT_ID, INSTANCE_ID));

CREATE TABLE FINGERPRINT_JOB_BUILD_RELATION
  (FINGERPRINT_ID        VARCHAR(256)    NOT NULL,
   INSTANCE_ID           CHAR(32)        NOT NULL,
   JOB                   VARCHAR(256)    NOT NULL,
   BUILD_NUMBER          INT             NOT NULL,
   PRIMARY KEY(FINGERPRINT_ID, INSTANCE_ID, JOB, BUILD_NUMBER),
   FOREIGN KEY(FINGERPRINT_ID, INSTANCE_ID) REFERENCES FINGERPRINT(FINGERPRINT_ID, INSTANCE_ID) ON DELETE CASCADE);

CREATE INDEX FINGERPRINT_JOB_BUILD_RELATION_INDEX
  ON FINGERPRINT_JOB_BUILD_RELATION (FINGERPRINT_ID, INSTANCE_ID);

CREATE TABLE FINGERPRINT_FACET_RELATION
  (FINGERPRINT_ID     VARCHAR(256)    NOT NULL,
   INSTANCE_ID        CHAR(32)        NOT NULL,
   FACET_NAME         VARCHAR(256)    NOT NULL,
   FACET_ENTRY        JSONB           NOT NULL,
   DELETION_BLOCKED   BOOLEAN         NOT NULL,
   PRIMARY KEY(FINGERPRINT_ID, INSTANCE_ID, FACET_NAME, FACET_ENTRY),
   FOREIGN KEY(FINGERPRINT_ID, INSTANCE_ID) REFERENCES FINGERPRINT(FINGERPRINT_ID, INSTANCE_ID) ON DELETE CASCADE);

CREATE INDEX FINGERPRINT_FACET_RELATION_INDEX
  ON FINGERPRINT_FACET_RELATION (FINGERPRINT_ID, INSTANCE_ID);
