/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.util.PipelineResultHandler;
import io.jenkins.plugins.util.QualityGateStatus;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.Issue;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PipelineResultHandlerTest {
    private static final String MESSAGE = "message";

    PipelineResultHandlerTest() {
    }

    @Test
    void shouldSetRunResult() {
        Run run = (Run)Mockito.mock(Run.class);
        FlowNode flowNode = (FlowNode)Mockito.mock(FlowNode.class);
        PipelineResultHandler handler = new PipelineResultHandler(run, flowNode);
        handler.publishResult(QualityGateStatus.PASSED, MESSAGE);
        Mockito.verifyNoInteractions((Object[])new Object[]{run});
        Mockito.verifyNoInteractions((Object[])new Object[]{flowNode});
        handler.publishResult(QualityGateStatus.WARNING, MESSAGE);
        ((Run)Mockito.verify((Object)run)).setResult(Result.UNSTABLE);
        ((FlowNode)Mockito.verify((Object)flowNode)).addOrReplaceAction((Action)Mockito.argThat(action -> this.hasFlowNode((Action)action, Result.UNSTABLE)));
        handler.publishResult(QualityGateStatus.FAILED, MESSAGE);
        ((Run)Mockito.verify((Object)run)).setResult(Result.FAILURE);
        ((FlowNode)Mockito.verify((Object)flowNode)).addOrReplaceAction((Action)Mockito.argThat(action -> this.hasFlowNode((Action)action, Result.FAILURE)));
    }

    @Test
    void shouldReplaceRunResult() {
        Run run = (Run)Mockito.mock(Run.class);
        FlowNode flowNode = (FlowNode)Mockito.mock(FlowNode.class);
        PipelineResultHandler handler = new PipelineResultHandler(run, flowNode);
        Mockito.when((Object)((WarningAction)flowNode.getPersistentAction(WarningAction.class))).thenReturn((Object)new WarningAction(Result.UNSTABLE));
        handler.publishResult(QualityGateStatus.WARNING, MESSAGE);
        ((FlowNode)Mockito.verify((Object)flowNode, (VerificationMode)Mockito.never())).addOrReplaceAction((Action)Mockito.any());
        handler.publishResult(QualityGateStatus.ERROR, MESSAGE);
        ((FlowNode)Mockito.verify((Object)flowNode)).addOrReplaceAction((Action)Mockito.argThat(action -> this.hasFlowNode((Action)action, Result.FAILURE)));
    }

    @Test
    @Issue(value="JENKINS-72059")
    void shouldSetStageResult() {
        Run run = (Run)Mockito.mock(Run.class);
        FlowNode flowNode = (FlowNode)Mockito.mock(FlowNode.class);
        PipelineResultHandler handler = new PipelineResultHandler(run, flowNode);
        handler.publishResult(QualityGateStatus.PASSED, MESSAGE);
        Mockito.verifyNoInteractions((Object[])new Object[]{run});
        Mockito.verifyNoInteractions((Object[])new Object[]{flowNode});
        handler.publishResult(QualityGateStatus.NOTE, MESSAGE);
        Mockito.verifyNoInteractions((Object[])new Object[]{run});
        ((FlowNode)Mockito.verify((Object)flowNode)).addOrReplaceAction((Action)Mockito.argThat(action -> this.hasFlowNode((Action)action, Result.UNSTABLE)));
        handler.publishResult(QualityGateStatus.ERROR, MESSAGE);
        Mockito.verifyNoInteractions((Object[])new Object[]{run});
        ((FlowNode)Mockito.verify((Object)flowNode)).addOrReplaceAction((Action)Mockito.argThat(action -> this.hasFlowNode((Action)action, Result.FAILURE)));
    }

    private boolean hasFlowNode(Action action, Result result) {
        if (action instanceof WarningAction) {
            WarningAction warningAction = (WarningAction)action;
            return result.equals(warningAction.getResult()) && MESSAGE.equals(warningAction.getMessage());
        }
        return false;
    }
}

