/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.util.FormValidation;
import java.util.Objects;
import org.apache.commons.lang3.Strings;
import org.apache.commons.text.StringEscapeUtils;
import org.assertj.core.api.AbstractAssert;

public class FormValidationAssert
extends AbstractAssert<FormValidationAssert, FormValidation> {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%nExpecting %s of:%n <%s>%nto be:%n <%s>%nbut was:%n <%s>.";

    public FormValidationAssert(FormValidation actual) {
        super((Object)actual, FormValidationAssert.class);
    }

    public static FormValidationAssert assertThat(FormValidation actual) {
        return new FormValidationAssert(actual);
    }

    public FormValidationAssert isError() {
        this.isNotNull();
        if (!Objects.equals(((FormValidation)this.actual).kind, FormValidation.Kind.ERROR)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"kind", this.actual, "ERROR", "not an ERROR"});
        }
        return this;
    }

    public FormValidationAssert isOk() {
        this.isNotNull();
        if (!Objects.equals(((FormValidation)this.actual).kind, FormValidation.Kind.OK)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"kind", this.actual, "OK", "not OK"});
        }
        return this;
    }

    public FormValidationAssert hasMessage(String expectedMessage) {
        this.isNotNull();
        String actualMessage = StringEscapeUtils.unescapeHtml4((String)((FormValidation)this.actual).getMessage());
        if (!Objects.equals(actualMessage, expectedMessage)) {
            this.failWithMessage(EXPECTED_BUT_WAS_MESSAGE, new Object[]{"message", StringEscapeUtils.unescapeHtml4((String)((FormValidation)this.actual).toString()), expectedMessage, actualMessage});
        }
        return this;
    }

    public FormValidationAssert hasMessageContaining(String expectedMessagePart) {
        this.isNotNull();
        String actualMessage = StringEscapeUtils.unescapeHtml4((String)((FormValidation)this.actual).getMessage());
        if (!Strings.CS.contains((CharSequence)actualMessage, (CharSequence)expectedMessagePart)) {
            this.failWithMessage("%nExpecting %s of:%n <%s>%nto contain:%n <%s>%nbut was:%n <%s>.", new Object[]{"message", StringEscapeUtils.unescapeHtml4((String)((FormValidation)this.actual).toString()), expectedMessagePart, actualMessage});
        }
        return this;
    }
}

