/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Run;
import io.jenkins.plugins.util.BuildResultNavigator;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BuildResultNavigatorTest {
    BuildResultNavigatorTest() {
    }

    @Test
    void shouldNavigateToSelectedBuild() {
        BuildResultNavigator navigator = new BuildResultNavigator();
        FreeStyleBuild current = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        FreeStyleProject job = (FreeStyleProject)Mockito.mock(FreeStyleProject.class);
        Mockito.when((Object)((FreeStyleProject)current.getParent())).thenReturn((Object)job);
        Mockito.when((Object)current.getNumber()).thenReturn((Object)100);
        FreeStyleBuild lastBuild = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        Mockito.when((Object)((FreeStyleBuild)job.getLastBuild())).thenReturn((Object)lastBuild);
        Mockito.when((Object)lastBuild.getDisplayName()).thenReturn((Object)"last-build");
        Mockito.when((Object)lastBuild.getNumber()).thenReturn((Object)111);
        ((OptionalAssert)Assertions.assertThat((Optional)navigator.getSameUrlForOtherBuild((Run)current, "http://localhost:8080/job/pipeline-analysis-model/100/spotbugs/", "spotbugs", "last-build")).isNotEmpty()).contains((Object)"http://localhost:8080/job/pipeline-analysis-model/111/spotbugs");
        Assertions.assertThat((Optional)navigator.getSameUrlForOtherBuild((Run)current, "http://localhost:8080/job/pipeline-analysis-model/different-url", "spotbugs", "last-build")).isEmpty();
    }

    @Test
    void shouldNavigateToSameBuild() {
        BuildResultNavigator navigator = new BuildResultNavigator();
        FreeStyleBuild current = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        FreeStyleProject job = (FreeStyleProject)Mockito.mock(FreeStyleProject.class);
        Mockito.when((Object)((FreeStyleProject)current.getParent())).thenReturn((Object)job);
        Mockito.when((Object)current.getNumber()).thenReturn((Object)100);
        Mockito.when((Object)current.getDisplayName()).thenReturn((Object)"#100");
        FreeStyleBuild lastBuild = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        Mockito.when((Object)((FreeStyleBuild)job.getLastBuild())).thenReturn((Object)lastBuild);
        Mockito.when((Object)lastBuild.getDisplayName()).thenReturn((Object)"#111");
        Mockito.when((Object)lastBuild.getNumber()).thenReturn((Object)111);
        Mockito.when((Object)((FreeStyleBuild)lastBuild.getPreviousBuild())).thenReturn((Object)current);
        ((OptionalAssert)Assertions.assertThat((Optional)navigator.getSameUrlForOtherBuild((Run)current, "http://localhost:8080/job/pipeline-analysis-model/100/spotbugs/", "spotbugs", "#100")).isNotEmpty()).contains((Object)"http://localhost:8080/job/pipeline-analysis-model/100/spotbugs");
        ((OptionalAssert)Assertions.assertThat((Optional)navigator.getSameUrlForOtherBuild((Run)current, "http://localhost:8080/job/pipeline-analysis-model/100/spotbugs/", "spotbugs", "#111")).isNotEmpty()).contains((Object)"http://localhost:8080/job/pipeline-analysis-model/111/spotbugs");
    }

    @Test
    void shouldNotFindBuildForUrl() {
        BuildResultNavigator navigator = new BuildResultNavigator();
        FreeStyleBuild current = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        FreeStyleProject job = (FreeStyleProject)Mockito.mock(FreeStyleProject.class);
        Mockito.when((Object)((FreeStyleProject)current.getParent())).thenReturn((Object)job);
        Mockito.when((Object)current.getNumber()).thenReturn((Object)100);
        FreeStyleBuild lastBuild = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        Mockito.when((Object)((FreeStyleBuild)job.getLastBuild())).thenReturn((Object)lastBuild);
        Mockito.when((Object)lastBuild.getDisplayName()).thenReturn((Object)"last-build");
        Mockito.when((Object)lastBuild.getNumber()).thenReturn((Object)111);
        Assertions.assertThat((Optional)navigator.getSameUrlForOtherBuild((Run)current, "http://localhost:8080/job/pipeline-analysis-model/100/spotbugs/", "spotbugs", "wrong-selection")).isEmpty();
    }

    @Test
    void shouldNotFindBuildIfThereIsNoLastBuild() {
        BuildResultNavigator navigator = new BuildResultNavigator();
        FreeStyleBuild current = (FreeStyleBuild)Mockito.mock(FreeStyleBuild.class);
        FreeStyleProject job = (FreeStyleProject)Mockito.mock(FreeStyleProject.class);
        Mockito.when((Object)((FreeStyleProject)current.getParent())).thenReturn((Object)job);
        Mockito.when((Object)current.getNumber()).thenReturn((Object)100);
        Assertions.assertThat((Optional)navigator.getSameUrlForOtherBuild((Run)current, "http://localhost:8080/job/pipeline-analysis-model/100/spotbugs/", "spotbugs", "wrong-selection")).isEmpty();
    }
}

