/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import io.jenkins.plugins.util.PluginLogger;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PluginLoggerTest {
    private static final String LOG_MESSAGE = "Hello ToolLogger!";
    private static final String TOOL_NAME = "test";
    private static final String EXPECTED_TOOL_PREFIX = "[test]";
    private static final String FIRST_MESSAGE = "One";
    private static final String SECOND_MESSAGE = "Two";

    PluginLoggerTest() {
    }

    @Test
    void shouldLogSingleAndMultipleLines() {
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        PluginLogger logger = new PluginLogger(printStream, TOOL_NAME);
        logger.log(LOG_MESSAGE, new Object[0]);
        ((PrintStream)Mockito.verify((Object)printStream)).println("[test] Hello ToolLogger!");
        PluginLogger loggerWithBraces = new PluginLogger(printStream, EXPECTED_TOOL_PREFIX);
        loggerWithBraces.log(LOG_MESSAGE, new Object[0]);
        ((PrintStream)Mockito.verify((Object)printStream, (VerificationMode)Mockito.times((int)2))).println("[test] Hello ToolLogger!");
        logger.logEachLine(Collections.emptyList());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{printStream});
        logger.logEachLine(Collections.singletonList(FIRST_MESSAGE));
        ((PrintStream)Mockito.verify((Object)printStream)).println("[test] One");
        logger.logEachLine(Arrays.asList(FIRST_MESSAGE, SECOND_MESSAGE));
        ((PrintStream)Mockito.verify((Object)printStream, (VerificationMode)Mockito.times((int)2))).println("[test] One");
        ((PrintStream)Mockito.verify((Object)printStream)).println("[test] Two");
    }
}

