/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.ResourceTest;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TopLevelItem;
import hudson.model.labels.LabelAtom;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.tasks.BatchFile;
import hudson.tasks.Builder;
import hudson.tasks.Shell;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Function;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.junit.jupiter.api.Tag;
import org.jvnet.hudson.test.JenkinsRule;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Tag(value="IntegrationTest")
public abstract class IntegrationTest
extends ResourceTest {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    protected static final String DOCKER_AGENT_NAME = "docker-agent";
    private static final String SSH_CREDENTIALS_ID = "sshCredentialsId";
    private static final String USER = "jenkins";
    private static final String PASSPHRASE = "";
    private static final int SSH_PORT = 22;
    private static final String AGENT_WORK_DIR = "/home/jenkins";
    private static final String WINDOWS_FILE_ACCESS_READ_ONLY = "RX";
    private static final String WINDOWS_FILE_DENY = "/deny";

    protected abstract JenkinsRule getJenkins();

    protected void createFileInWorkspace(TopLevelItem job, String fileName, String content) {
        try {
            FilePath workspace = this.getWorkspace(job);
            FilePath child = workspace.child(fileName);
            child.copyFrom((InputStream)new ByteArrayInputStream(content.getBytes(UTF_8)));
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void copyMultipleFilesToWorkspace(TopLevelItem job, String ... fileNames) {
        this.copyWorkspaceFiles(job, fileNames, file -> Path.of(file, new String[0]).getFileName().toString());
    }

    protected void copySingleFileToWorkspace(TopLevelItem job, String fileName) {
        FilePath workspace = this.getWorkspace(job);
        this.copySingleFileToWorkspace(workspace, fileName, fileName);
    }

    protected void copySingleFileToWorkspace(TopLevelItem job, String from, String to) {
        FilePath workspace = this.getWorkspace(job);
        this.copySingleFileToWorkspace(workspace, from, to);
    }

    protected void copyWorkspaceFiles(TopLevelItem job, String[] fileNames, Function<String, String> fileNameMapper) {
        Arrays.stream(fileNames).forEach(fileName -> this.copySingleFileToWorkspace(job, (String)fileName, (String)fileNameMapper.apply((String)fileName)));
    }

    protected String getConsoleLog(Run<?, ?> build) {
        try {
            return JenkinsRule.getLog(build);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void copyFileToWorkspace(TopLevelItem job, String fileName) {
        FilePath workspace = this.getWorkspace(job);
        this.copyFileToWorkspace(workspace, fileName, fileName);
    }

    protected void copyFileToWorkspace(TopLevelItem job, String from, String to) {
        FilePath workspace = this.getWorkspace(job);
        this.copyFileToWorkspace(workspace, from, to);
    }

    protected void copyFilesToWorkspace(TopLevelItem job, String ... fileNames) {
        Arrays.stream(fileNames).forEach(fileName -> this.copyFileToWorkspace(job, (String)fileName, (String)fileName));
    }

    protected void copyDirectoryToWorkspace(TopLevelItem job, String directory) {
        try {
            URL resource = this.getTestResourceClass().getResource(directory);
            ((AbstractUrlAssert)Assertions.assertThat((URL)resource).as("No such file: %s", new Object[]{directory})).isNotNull();
            FilePath destination = new FilePath(new File(resource.getFile()));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)destination.exists()).as("Directory %s does not exist", new Object[]{resource.getFile()})).isTrue();
            destination.copyRecursiveTo(this.getWorkspace(job));
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void copyFileToWorkspace(FilePath workspace, String from, String to) {
        try {
            workspace.child(to).copyFrom(this.asInputStream(from));
            System.out.format("Copying file '%s' as workspace file '%s'%n", from, to);
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected FilePath getWorkspace(TopLevelItem job) {
        FilePath workspace = this.getJenkins().jenkins.getWorkspaceFor(job);
        Assertions.assertThat((Object)workspace).isNotNull();
        return workspace;
    }

    protected String getAbsolutePathOfWorkspaceFile(TopLevelItem job, String fileName) {
        return new PathUtil().createAbsolutePath(this.getWorkspace(job).getRemote(), fileName);
    }

    private void copySingleFileToWorkspace(FilePath workspace, String from, String to) {
        try {
            workspace.child(to).copyFrom(this.asInputStream(from));
            System.out.format("Copying file '%s' as workspace file '%s'%n (workspace '%s')", from, to, workspace);
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Slave createAgent(String label) {
        try {
            return this.getJenkins().createOnlineSlave((Label)new LabelAtom(label));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Node createDockerAgent(AgentContainer agentContainer, String label) {
        try {
            Node agent = this.createDockerAgent(agentContainer);
            agent.setLabelString(label);
            return agent;
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected Node createDockerAgent(AgentContainer agentContainer) {
        try {
            Node node = this.createPermanentAgent(agentContainer.getHost(), agentContainer.getMappedPort(22));
            this.waitForAgentConnected(node);
            return node;
        }
        catch (Descriptor.FormException | IOException | InterruptedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private Node createPermanentAgent(String host, int sshPort) throws Descriptor.FormException, IOException {
        String privateKey = this.toString("/ssh/rsa_private_key");
        BasicSSHUserPrivateKey.DirectEntryPrivateKeySource privateKeySource = new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey);
        BasicSSHUserPrivateKey credentials = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, SSH_CREDENTIALS_ID, USER, (BasicSSHUserPrivateKey.PrivateKeySource)privateKeySource, PASSPHRASE, "Private Key ssh credentials");
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(credentials));
        SSHLauncher launcher = new SSHLauncher(host, sshPort, SSH_CREDENTIALS_ID);
        launcher.setSshHostKeyVerificationStrategy((SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        DumbSlave agent = new DumbSlave(DOCKER_AGENT_NAME, AGENT_WORK_DIR, (ComputerLauncher)launcher);
        agent.setNodeProperties(Collections.singletonList(new EnvironmentVariablesNodeProperty(new EnvironmentVariablesNodeProperty.Entry[]{new EnvironmentVariablesNodeProperty.Entry("JAVA_HOME", "/usr/lib/jvm/java-11-openjdk-amd64")})));
        Jenkins jenkins = this.getJenkins().jenkins;
        jenkins.addNode((Node)agent);
        return jenkins.getNode(agent.getNodeName());
    }

    private void waitForAgentConnected(Node node) throws InterruptedException {
        for (int count = 0; !Objects.requireNonNull(node.toComputer()).isOnline() && count < 150; ++count) {
            Thread.sleep(1000L);
        }
        Assertions.assertThat((boolean)Objects.requireNonNull(node.toComputer()).isOnline()).isTrue();
    }

    protected Slave createAgentWithEnabledSecurity(String label) {
        try {
            Slave agent = this.createAgent(label);
            FilePath child = this.getJenkins().getInstance().getRootPath().child("secrets/filepath-filters.d/30-default.conf");
            child.delete();
            child.write(PASSPHRASE, "ISO_8859_1");
            this.getJenkins().jenkins.save();
            return agent;
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected FilePath getAgentWorkspace(Node agent, TopLevelItem job) {
        FilePath workspace = agent.getWorkspaceFor(job);
        Assertions.assertThat((Object)workspace).isNotNull();
        return workspace;
    }

    protected void createFileInAgentWorkspace(Node agent, TopLevelItem job, String fileName, String content) {
        try {
            FilePath workspace = this.getAgentWorkspace(agent, job);
            FilePath child = workspace.child(fileName);
            child.copyFrom((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void copySingleFileToAgentWorkspace(Node agent, TopLevelItem job, String fileName) {
        this.copySingleFileToAgentWorkspace(agent, job, fileName, fileName);
    }

    protected void copySingleFileToAgentWorkspace(Node agent, TopLevelItem job, String from, String to) {
        FilePath workspace = this.getAgentWorkspace(agent, job);
        this.copyFileToWorkspace(workspace, from, to);
    }

    protected FreeStyleProject createFreeStyleProject() {
        return this.createProject(FreeStyleProject.class);
    }

    protected FreeStyleProject createFreeStyleProjectWithWorkspaceFiles(String ... fileNames) {
        FreeStyleProject job = this.createFreeStyleProject();
        this.copyFilesToWorkspace((TopLevelItem)job, fileNames);
        return job;
    }

    protected <T extends TopLevelItem> T createProject(Class<T> type) {
        try {
            return (T)this.getJenkins().createProject(type);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected <T extends TopLevelItem> T createProject(Class<T> type, String name) {
        try {
            return (T)this.getJenkins().createProject(type, name);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected CpsFlowDefinition asStage(String ... steps) {
        StringBuilder script = new StringBuilder(1024);
        script.append("node {\n");
        script.append("  stage ('Integration Test') {\n");
        for (String step : steps) {
            script.append("    ");
            script.append(step);
            script.append('\n');
        }
        script.append("  }\n");
        script.append("}\n");
        String jenkinsFile = script.toString();
        this.logJenkinsFile(jenkinsFile);
        return this.createPipelineScript(jenkinsFile);
    }

    protected WorkflowJob createPipelineWithWorkspaceFiles(String ... fileNames) {
        WorkflowJob job = this.createPipeline();
        this.copyFilesToWorkspace((TopLevelItem)job, fileNames);
        return job;
    }

    protected WorkflowJob createPipeline() {
        return this.createProject(WorkflowJob.class);
    }

    protected WorkflowJob createPipeline(String name) {
        return this.createProject(WorkflowJob.class, name);
    }

    protected FlowDefinition readJenkinsFile(String fileName) {
        String script = this.toString(fileName);
        this.logJenkinsFile(script);
        return this.createPipelineScript(script);
    }

    protected CpsFlowDefinition createPipelineScript(String script) {
        try {
            return new CpsFlowDefinition(script, true);
        }
        catch (Descriptor.FormException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected Run<?, ?> buildSuccessfully(ParameterizedJobMixIn.ParameterizedJob<?, ?> job) {
        return this.buildWithResult(job, Result.SUCCESS);
    }

    protected void assertSuccessfulBuild(Run<?, ?> run) {
        try {
            this.getJenkins().assertBuildStatus(Result.SUCCESS, run);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected Run<?, ?> buildWithResult(ParameterizedJobMixIn.ParameterizedJob<?, ?> job, Result expectedResult) {
        try {
            return this.getJenkins().assertBuildStatus(expectedResult, (Future)Objects.requireNonNull(job.scheduleBuild2(0, new Action[0])));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private void logJenkinsFile(String script) {
        System.out.println("----------------------------------------------------------------------");
        System.out.println(script);
        System.out.println("----------------------------------------------------------------------");
    }

    protected void printConsoleLog(Run<?, ?> build) {
        System.out.println("----- Console Log -----");
        try (Reader reader = build.getLogReader();
             BufferedReader bufferedReader = new BufferedReader(reader);){
            bufferedReader.lines().forEach(System.out::println);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected void makeFileUnreadable(Path file) {
        this.makeFileUnreadable(file.toString());
    }

    protected void makeFileUnreadable(String absolutePath) {
        File nonReadableFile = new File(absolutePath);
        if (Functions.isWindows()) {
            this.setAccessModeOnWindows(absolutePath, WINDOWS_FILE_DENY, WINDOWS_FILE_ACCESS_READ_ONLY);
        } else {
            Assertions.assertThat((boolean)nonReadableFile.setReadable(false, false)).isTrue();
            ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)nonReadableFile.canRead()).as("File \u00b4%s\u00b4 could not be made unreadable (OS configuration problem?)", new Object[]{absolutePath})).isFalse();
        }
    }

    private void setAccessModeOnWindows(String path, String command, String accessMode) {
        try {
            Process process = Runtime.getRuntime().exec("icacls \"" + path + "\" " + command + " *S-1-1-0:" + accessMode);
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Builder addScriptStep(FreeStyleProject project, String script) {
        Object item = Functions.isWindows() ? new BatchFile(script) : new Shell(script);
        project.getBuildersList().add(item);
        return item;
    }

    protected void cleanWorkspace(TopLevelItem job) {
        try {
            this.getWorkspace(job).deleteContents();
        }
        catch (IOException | InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Builder addFailureStep(FreeStyleProject project) {
        return this.addScriptStep(project, "exit 1");
    }

    protected void removeBuilder(FreeStyleProject project, Builder builder) {
        project.getBuildersList().remove((Object)builder);
    }

    protected String join(String ... arguments) {
        StringBuilder builder = new StringBuilder();
        for (String argument : arguments) {
            builder.append(", ");
            builder.append(argument);
        }
        return builder.toString();
    }

    protected JenkinsRule.JSONWebResponse callJsonRemoteApi(String url) {
        try {
            return this.getJenkins().getJSON(url);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected Document callXmlRemoteApi(String url) {
        Document document;
        block8: {
            JenkinsRule.WebClient webClient = this.getJenkins().createWebClient();
            try {
                document = webClient.goToXml(url).getXmlDocument();
                if (webClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (webClient != null) {
                        try {
                            webClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new AssertionError((Object)e);
                }
            }
            webClient.close();
        }
        return document;
    }

    public static final class AgentContainer
    extends GenericContainer<AgentContainer> {
        public AgentContainer() {
            super((Future)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile(IntegrationTest.DOCKER_AGENT_NAME, false).withFileFromClasspath("ssh/authorized_keys", "/ssh/authorized_keys")).withFileFromClasspath("ssh/rsa-key", "/ssh/rsa_private_key")).withFileFromClasspath("ssh/rsa-key.pub", "/ssh/rsa_public_key")).withFileFromClasspath("ssh/sshd_config", "/ssh/sshd_config")).withFileFromClasspath("Dockerfile", "/ssh/Dockerfile"));
            this.setExposedPorts(Collections.singletonList(22));
        }
    }
}

