/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.FilteredLog;
import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateEvaluator;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.QualityGateStatus;
import io.jenkins.plugins.util.ResultHandler;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class QualityGateEvaluatorTest {
    private static final String FAILURE_MESSAGE = "-> Some quality gates have been missed: overall result is FAILURE";

    QualityGateEvaluatorTest() {
    }

    @Test
    void shouldDoNothing() {
        FilteredLog log = new FilteredLog();
        QualityGateResult result = this.createEvaluator(log);
        Assertions.assertThat((Object)result).hasToString("INACTIVE");
        Assertions.assertThat((Comparable)result.getOverallStatus()).isEqualTo((Object)QualityGateStatus.INACTIVE);
        Assertions.assertThat((List)log.getInfoMessages()).contains((Object[])new String[]{"No quality gates have been set - skipping"});
    }

    private QualityGateResult createEvaluator(FilteredLog log) {
        QualityGateEvaluator evaluator = (QualityGateEvaluator)Mockito.spy(QualityGateEvaluator.class);
        return evaluator.evaluate((ResultHandler)Mockito.mock(ResultHandler.class), log);
    }

    @Test
    void shouldCreateSuccessfulResult() {
        FilteredLog log = new FilteredLog();
        QualityGateEvaluator evaluator = (QualityGateEvaluator)Mockito.spy(QualityGateEvaluator.class);
        this.addQualityGate(evaluator);
        ResultHandler resultHandler = (ResultHandler)Mockito.mock(ResultHandler.class);
        QualityGateResult result = evaluator.evaluate(resultHandler, log);
        Assertions.assertThat((Object)result).hasToString("INACTIVE");
        Assertions.assertThat((Comparable)result.getOverallStatus()).isEqualTo((Object)QualityGateStatus.INACTIVE);
        Assertions.assertThat((List)log.getInfoMessages()).contains((Object[])new String[]{"Evaluating quality gates", "-> All quality gates have been passed"});
        Mockito.verifyNoInteractions((Object[])new Object[]{resultHandler});
    }

    @Test
    void shouldCreateFailedResult() {
        FilteredLog log = new FilteredLog();
        QualityGateEvaluator evaluator = (QualityGateEvaluator)Mockito.spy(QualityGateEvaluator.class);
        QualityGateResult qualityGateResult = (QualityGateResult)Mockito.mock(QualityGateResult.class);
        Mockito.when((Object)qualityGateResult.isSuccessful()).thenReturn((Object)false);
        Mockito.when((Object)qualityGateResult.getOverallStatus()).thenReturn((Object)QualityGateStatus.ERROR);
        Mockito.when((Object)evaluator.createResult()).thenReturn((Object)qualityGateResult);
        this.addQualityGate(evaluator);
        ResultHandler resultHandler = (ResultHandler)Mockito.mock(ResultHandler.class);
        QualityGateResult result = evaluator.evaluate(resultHandler, log);
        Assertions.assertThat((Comparable)result.getOverallStatus()).isEqualTo((Object)QualityGateStatus.ERROR);
        Assertions.assertThat((List)log.getInfoMessages()).contains((Object[])new String[]{"Evaluating quality gates", FAILURE_MESSAGE});
        ((ResultHandler)Mockito.verify((Object)resultHandler)).publishResult(QualityGateStatus.ERROR, FAILURE_MESSAGE);
    }

    private void addQualityGate(QualityGateEvaluator evaluator) {
        QualityGate qualityGate = (QualityGate)Mockito.mock(QualityGate.class);
        evaluator.addAll(List.of(qualityGate));
    }
}

