// CHECKSTYLE:OFF

package io.jenkins.plugins.util;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code QualityGate.Failure}: {@code Fail the build}.
     * 
     * @return
     *     {@code Fail the build}
     */
    public static String QualityGate_Failure() {
        return holder.format("QualityGate.Failure");
    }

    /**
     * Key {@code QualityGate.Failure}: {@code Fail the build}.
     * 
     * @return
     *     {@code Fail the build}
     */
    public static Localizable _QualityGate_Failure() {
        return new Localizable(holder, "QualityGate.Failure");
    }

    /**
     * Key {@code QualityGate.FailureStage}: {@code Fail the step but not the

     * build}.
     * 
     * @return
     *     {@code Fail the step but not the build}
     */
    public static String QualityGate_FailureStage() {
        return holder.format("QualityGate.FailureStage");
    }

    /**
     * Key {@code QualityGate.FailureStage}: {@code Fail the step but not the

     * build}.
     * 
     * @return
     *     {@code Fail the step but not the build}
     */
    public static Localizable _QualityGate_FailureStage() {
        return new Localizable(holder, "QualityGate.FailureStage");
    }

    /**
     * Key {@code QualityGate.UnstableRun}: {@code Mark the step and the

     * build as unstable}.
     * 
     * @return
     *     {@code Mark the step and the build as unstable}
     */
    public static String QualityGate_UnstableRun() {
        return holder.format("QualityGate.UnstableRun");
    }

    /**
     * Key {@code QualityGate.UnstableRun}: {@code Mark the step and the

     * build as unstable}.
     * 
     * @return
     *     {@code Mark the step and the build as unstable}
     */
    public static Localizable _QualityGate_UnstableRun() {
        return new Localizable(holder, "QualityGate.UnstableRun");
    }

    /**
     * Key {@code QualityGate.UnstableStage}: {@code Mark the step as

     * unstable}.
     * 
     * @return
     *     {@code Mark the step as unstable}
     */
    public static String QualityGate_UnstableStage() {
        return holder.format("QualityGate.UnstableStage");
    }

    /**
     * Key {@code QualityGate.UnstableStage}: {@code Mark the step as

     * unstable}.
     * 
     * @return
     *     {@code Mark the step as unstable}
     */
    public static Localizable _QualityGate_UnstableStage() {
        return new Localizable(holder, "QualityGate.UnstableStage");
    }

    /**
     * Key {@code QualityGate.Unstable}: {@code Mark the build as unstable}.
     * 
     * @return
     *     {@code Mark the build as unstable}
     */
    public static String QualityGate_Unstable() {
        return holder.format("QualityGate.Unstable");
    }

    /**
     * Key {@code QualityGate.Unstable}: {@code Mark the build as unstable}.
     * 
     * @return
     *     {@code Mark the build as unstable}
     */
    public static Localizable _QualityGate_Unstable() {
        return new Localizable(holder, "QualityGate.Unstable");
    }

    /**
     * Key {@code QualityGate.FailureRun}: {@code Fail the step and the

     * build}.
     * 
     * @return
     *     {@code Fail the step and the build}
     */
    public static String QualityGate_FailureRun() {
        return holder.format("QualityGate.FailureRun");
    }

    /**
     * Key {@code QualityGate.FailureRun}: {@code Fail the step and the

     * build}.
     * 
     * @return
     *     {@code Fail the step and the build}
     */
    public static Localizable _QualityGate_FailureRun() {
        return new Localizable(holder, "QualityGate.FailureRun");
    }

    /**
     * Key {@code FieldValidator.Error.WrongIdFormat}: {@code An ID must

     * match the regexp pattern {0}, but {1} does not.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An ID must match the regexp pattern {0}, but {1} does not.}
     */
    public static String FieldValidator_Error_WrongIdFormat(Object arg0, Object arg1) {
        return holder.format("FieldValidator.Error.WrongIdFormat", arg0, arg1);
    }

    /**
     * Key {@code FieldValidator.Error.WrongIdFormat}: {@code An ID must

     * match the regexp pattern {0}, but {1} does not.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An ID must match the regexp pattern {0}, but {1} does not.}
     */
    public static Localizable _FieldValidator_Error_WrongIdFormat(Object arg0, Object arg1) {
        return new Localizable(holder, "FieldValidator.Error.WrongIdFormat", arg0, arg1);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must

     * be a supported encoding of the Java platform, see: <a rel="noopener

     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,

     *     see: <a rel="noopener noreferrer"

     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static String FieldValidator_Error_DefaultEncoding(Object arg0) {
        return holder.format("FieldValidator.Error.DefaultEncoding", arg0);
    }

    /**
     * Key {@code FieldValidator.Error.DefaultEncoding}: {@code Encoding must

     * be a supported encoding of the Java platform, see: <a rel="noopener

     * noreferrer" href="{0}">java.nio.charset.Charset</a>}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Encoding must be a supported encoding of the Java platform,

     *     see: <a rel="noopener noreferrer"

     *     href="{0}">java.nio.charset.Charset</a>}
     */
    public static Localizable _FieldValidator_Error_DefaultEncoding(Object arg0) {
        return new Localizable(holder, "FieldValidator.Error.DefaultEncoding", arg0);
    }

}
