/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.SerializableTest;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.util.AgentFileVisitor;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.Mockito;

class AgentFileVisitorTest
extends SerializableTest<StringScanner> {
    private static final String CONTENT = "Hello World!";
    private static final String PATTERN = "**/*.txt";
    private static final String ENCODING = "UTF-8";
    @TempDir
    private File workspace;

    AgentFileVisitorTest() {
    }

    @DisplayName(value="Should report error on empty results")
    @CsvSource(value={"true, enabled", "false, disabled"})
    @ParameterizedTest(name="{index} => followSymbolicLinks={0}, message={1}")
    void shouldReportErrorOnEmptyResults(boolean followLinks, String message) {
        StringScanner scanner = new StringScanner(PATTERN, ENCODING, followLinks, true, this.createFileSystemFacade(followLinks, new String[0]));
        AgentFileVisitor.FileVisitorResult actualResult = scanner.invoke(this.workspace, null);
        Assertions.assertThat((List)actualResult.getResults()).isEmpty();
        Assertions.assertThat((List)actualResult.getLog().getInfoMessages()).containsExactly((Object[])new String[]{"Searching for all files in '/absolute/path' that match the pattern '**/*.txt'", "Traversing of symbolic links: " + message});
        Assertions.assertThat((List)actualResult.getLog().getErrorMessages()).containsExactly((Object[])new String[]{"Errors during parsing", "No files found for pattern '**/*.txt'. Configuration error?"});
        Assertions.assertThat((boolean)actualResult.hasErrors()).isTrue();
    }

    @DisplayName(value="Should report error on single result")
    @CsvSource(value={"true, enabled", "false, disabled"})
    @ParameterizedTest(name="{index} => followSymbolicLinks={0}, message={1}")
    void shouldReturnSingleResult(boolean followLinks, String message) {
        StringScanner scanner = new StringScanner(PATTERN, ENCODING, followLinks, true, this.createFileSystemFacade(followLinks, "/one.txt"));
        AgentFileVisitor.FileVisitorResult actualResult = scanner.invoke(this.workspace, null);
        Assertions.assertThat((List)actualResult.getResults()).containsExactly((Object[])new String[]{"Hello World!1"});
        Assertions.assertThat((List)actualResult.getLog().getInfoMessages()).containsExactly((Object[])new String[]{"Searching for all files in '/absolute/path' that match the pattern '**/*.txt'", "Traversing of symbolic links: " + message, "-> found 1 file", "Successfully processed file '/one.txt'"});
        Assertions.assertThat((List)actualResult.getLog().getErrorMessages()).isEmpty();
        Assertions.assertThat((boolean)actualResult.hasErrors()).isFalse();
    }

    @DisplayName(value="Should report error on single result")
    @CsvSource(value={"true, enabled", "false, disabled"})
    @ParameterizedTest(name="{index} => followSymbolicLinks={0}, message={1}")
    void shouldReturnMultipleResults(boolean followLinks, String message) {
        StringScanner scanner = new StringScanner(PATTERN, ENCODING, followLinks, true, this.createFileSystemFacade(followLinks, "/one.txt", "/two.txt"));
        AgentFileVisitor.FileVisitorResult actualResult = scanner.invoke(this.workspace, null);
        Assertions.assertThat((List)actualResult.getResults()).containsExactly((Object[])new String[]{"Hello World!1", "Hello World!2"});
        Assertions.assertThat((List)actualResult.getLog().getInfoMessages()).containsExactly((Object[])new String[]{"Searching for all files in '/absolute/path' that match the pattern '**/*.txt'", "Traversing of symbolic links: " + message, "-> found 2 files", "Successfully processed file '/one.txt'", "Successfully processed file '/two.txt'"});
        Assertions.assertThat((List)actualResult.getLog().getErrorMessages()).isEmpty();
        Assertions.assertThat((boolean)actualResult.hasErrors()).isFalse();
    }

    @Test
    @DisplayName(value="Should log error for empty or forbidden files")
    void shouldLogErrorForEmptyAndForbiddenFiles() {
        AgentFileVisitor.FileSystemFacade fileSystemFacade = this.createFileSystemFacade(true, "/one.txt", "/two.txt", "empty.txt", "not-readable.txt");
        Path empty = this.workspace.toPath().resolve("empty.txt");
        Mockito.when((Object)fileSystemFacade.resolve(this.workspace, "empty.txt")).thenReturn((Object)empty);
        Mockito.when((Object)fileSystemFacade.isEmpty(empty)).thenReturn((Object)true);
        Path notReadable = this.workspace.toPath().resolve("not-readable.txt");
        Mockito.when((Object)fileSystemFacade.resolve(this.workspace, "not-readable.txt")).thenReturn((Object)notReadable);
        Mockito.when((Object)fileSystemFacade.isNotReadable(notReadable)).thenReturn((Object)true);
        StringScanner scanner = new StringScanner(PATTERN, ENCODING, true, true, fileSystemFacade);
        AgentFileVisitor.FileVisitorResult actualResult = scanner.invoke(this.workspace, null);
        Assertions.assertThat((List)actualResult.getResults()).containsExactly((Object[])new String[]{"Hello World!1", "Hello World!2"});
        Assertions.assertThat((List)actualResult.getLog().getInfoMessages()).contains((Object[])new String[]{"Searching for all files in '/absolute/path' that match the pattern '**/*.txt'", "-> found 4 files", "Successfully processed file '/one.txt'", "Successfully processed file '/two.txt'"});
        Assertions.assertThat((boolean)actualResult.hasErrors()).isTrue();
        Assertions.assertThat((List)actualResult.getLog().getErrorMessages()).containsExactly((Object[])new String[]{"Errors during parsing", "Skipping file 'empty.txt' because it's empty", "Skipping file 'not-readable.txt' because Jenkins has no permission to read the file"});
    }

    @Test
    @DisplayName(value="Should skip logging of errors when parsing empty files")
    void shouldSkipLoggingOfErrorsForEmptyFiles() {
        AgentFileVisitor.FileSystemFacade fileSystemFacade = this.createFileSystemFacade(true, "/one.txt", "/two.txt", "empty.txt");
        Path empty = this.workspace.toPath().resolve("empty.txt");
        Mockito.when((Object)fileSystemFacade.resolve(this.workspace, "empty.txt")).thenReturn((Object)empty);
        Mockito.when((Object)fileSystemFacade.isEmpty(empty)).thenReturn((Object)true);
        StringScanner scanner = new StringScanner(PATTERN, ENCODING, true, false, fileSystemFacade);
        AgentFileVisitor.FileVisitorResult actualResult = scanner.invoke(this.workspace, null);
        Assertions.assertThat((List)actualResult.getResults()).containsExactly((Object[])new String[]{"Hello World!1", "Hello World!2"});
        Assertions.assertThat((List)actualResult.getLog().getInfoMessages()).contains((Object[])new String[]{"Searching for all files in '/absolute/path' that match the pattern '**/*.txt'", "-> found 3 files", "Successfully processed file '/one.txt'", "Successfully processed file '/two.txt'", "Skipping file 'empty.txt' because it's empty"});
        Assertions.assertThat((boolean)actualResult.hasErrors()).isFalse();
        Assertions.assertThat((List)actualResult.getLog().getErrorMessages()).isEmpty();
    }

    @Test
    @DisplayName(value="Should log error if no results are returned")
    void shouldLogErrorIfNoResultIsAvailable() {
        AgentFileVisitor.FileSystemFacade fileSystemFacade = this.createFileSystemFacade(false, "/one.txt");
        EmptyScanner scanner = new EmptyScanner(fileSystemFacade);
        AgentFileVisitor.FileVisitorResult actualResult = scanner.invoke(this.workspace, null);
        Assertions.assertThat((List)actualResult.getResults()).isEmpty();
        Assertions.assertThat((List)actualResult.getLog().getInfoMessages()).containsExactly((Object[])new String[]{"Searching for all files in '/absolute/path' that match the pattern '**/*.txt'", "Traversing of symbolic links: disabled", "-> found 1 file"});
        Assertions.assertThat((boolean)actualResult.hasErrors()).isTrue();
        Assertions.assertThat((List)actualResult.getLog().getErrorMessages()).containsExactly((Object[])new String[]{"Errors during parsing", "No result created for file '/one.txt' due to some errors"});
    }

    private AgentFileVisitor.FileSystemFacade createFileSystemFacade(boolean followLinks, String ... files) {
        AgentFileVisitor.FileSystemFacade fileSystem = (AgentFileVisitor.FileSystemFacade)Mockito.mock(AgentFileVisitor.FileSystemFacade.class);
        Mockito.when((Object)fileSystem.getAbsolutePath((File)Mockito.any())).thenReturn((Object)"/absolute/path");
        Mockito.when((Object)fileSystem.find(PATTERN, followLinks, this.workspace)).thenReturn((Object)files);
        return fileSystem;
    }

    @Override
    protected StringScanner createSerializable() {
        return new StringScanner(PATTERN, ENCODING, true, true, this.createFileSystemFacade(true, new String[0]));
    }

    static class StringScanner
    extends AgentFileVisitor<String> {
        private static final long serialVersionUID = -6902473746775046311L;
        private int counter = 1;

        @VisibleForTesting
        protected StringScanner(String filePattern, String encoding, boolean followSymbolicLinks, boolean errorOnEmptyFiles, AgentFileVisitor.FileSystemFacade fileSystemFacade) {
            super(filePattern, encoding, followSymbolicLinks, errorOnEmptyFiles, fileSystemFacade);
        }

        protected Optional<String> processFile(Path file, Charset charset, FilteredLog log) {
            return Optional.of(AgentFileVisitorTest.CONTENT + this.counter++);
        }

        @SuppressFBWarnings(value={"EQ_ALWAYS_TRUE"}, justification="Required for serializable test")
        public boolean equals(Object o) {
            return true;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class EmptyScanner
    extends AgentFileVisitor<String> {
        private static final long serialVersionUID = 3700448215163706213L;

        @VisibleForTesting
        protected EmptyScanner(AgentFileVisitor.FileSystemFacade fileSystemFacade) {
            super(AgentFileVisitorTest.PATTERN, AgentFileVisitorTest.ENCODING, false, false, fileSystemFacade);
        }

        protected Optional<String> processFile(Path file, Charset charset, FilteredLog log) {
            return Optional.empty();
        }

        @SuppressFBWarnings(value={"EQ_ALWAYS_TRUE"}, justification="Required for serializable test")
        public boolean equals(Object o) {
            return true;
        }

        public int hashCode() {
            return 0;
        }
    }
}

