/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.agent;

import io.jenkins.plugins.projectenv.agent.AgentInfo;
import io.jenkins.plugins.projectenv.agent.Architecture;
import io.jenkins.plugins.projectenv.agent.OperatingSystem;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class AgentInfoCallable
extends MasterToSlaveCallable<AgentInfo, Exception> {
    public AgentInfo call() {
        return AgentInfo.builder().lineSeparator(System.lineSeparator()).operatingSystem(this.getOperatingSystem()).architecture(this.getArchitecture()).build();
    }

    private OperatingSystem getOperatingSystem() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return OperatingSystem.WINDOWS;
        }
        if (SystemUtils.IS_OS_MAC) {
            return OperatingSystem.MACOS;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return OperatingSystem.LINUX;
        }
        throw new IllegalStateException("unsupported OS " + SystemUtils.OS_NAME);
    }

    private Architecture getArchitecture() {
        if (StringUtils.equalsIgnoreCase((CharSequence)SystemUtils.OS_ARCH, (CharSequence)"aarch64")) {
            return Architecture.AARCH64;
        }
        return Architecture.AMD64;
    }
}

