/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.libs.LibraryCachingConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LibraryConfiguration
extends AbstractDescribableImpl<LibraryConfiguration> {
    private final String name;
    private final LibraryRetriever retriever;
    private String defaultVersion;
    private boolean implicit;
    private boolean allowVersionOverride = true;
    private boolean allowVersionEnvvar = false;
    private boolean allowBRANCH_NAME = false;
    private boolean allowBRANCH_NAME_PR = false;
    private boolean traceDefaultedVersion = false;
    private boolean includeInChangesets = true;
    private LibraryCachingConfiguration cachingConfiguration = null;

    @DataBoundConstructor
    public LibraryConfiguration(String name, LibraryRetriever retriever) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.retriever = retriever;
    }

    public String getName() {
        return this.name;
    }

    public LibraryRetriever getRetriever() {
        return this.retriever;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @DataBoundSetter
    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = Util.fixEmptyAndTrim((String)defaultVersion);
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    @DataBoundSetter
    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isAllowVersionOverride() {
        return this.allowVersionOverride;
    }

    @DataBoundSetter
    public void setAllowVersionOverride(boolean allowVersionOverride) {
        this.allowVersionOverride = allowVersionOverride;
    }

    public boolean isAllowVersionEnvvar() {
        return this.allowVersionEnvvar;
    }

    @DataBoundSetter
    public void setAllowVersionEnvvar(boolean allowVersionEnvvar) {
        this.allowVersionEnvvar = allowVersionEnvvar;
    }

    public boolean isAllowBRANCH_NAME() {
        return this.allowBRANCH_NAME;
    }

    @DataBoundSetter
    public void setAllowBRANCH_NAME(boolean allowBRANCH_NAME) {
        this.allowBRANCH_NAME = allowBRANCH_NAME;
    }

    public boolean isTraceDefaultedVersion() {
        return this.traceDefaultedVersion;
    }

    @DataBoundSetter
    public void setTraceDefaultedVersion(boolean traceDefaultedVersion) {
        this.traceDefaultedVersion = traceDefaultedVersion;
    }

    public boolean isAllowBRANCH_NAME_PR() {
        return this.allowBRANCH_NAME_PR;
    }

    @DataBoundSetter
    public void setAllowBRANCH_NAME_PR(boolean allowBRANCH_NAME_PR) {
        this.allowBRANCH_NAME_PR = allowBRANCH_NAME_PR;
    }

    public boolean getIncludeInChangesets() {
        return this.includeInChangesets;
    }

    @DataBoundSetter
    public void setIncludeInChangesets(boolean includeInChangesets) {
        this.includeInChangesets = includeInChangesets;
    }

    public LibraryCachingConfiguration getCachingConfiguration() {
        return this.cachingConfiguration;
    }

    @DataBoundSetter
    public void setCachingConfiguration(LibraryCachingConfiguration cachingConfiguration) {
        this.cachingConfiguration = cachingConfiguration;
    }

    @NonNull
    boolean defaultedChangelogs(@CheckForNull Boolean changelog) throws AbortException {
        if (changelog == null) {
            return this.includeInChangesets;
        }
        return changelog;
    }

    private boolean isDefaultedVersionSCMSupported(SCM scm) {
        return "hudson.plugins.git.GitSCM".equals(scm.getClass().getName());
    }

    private String extractDefaultedVersionGitSCM(@NonNull SCM scm, @NonNull Run<?, ?> run, @NonNull TaskListener listener, PrintStream logger) {
        if (!"hudson.plugins.git.GitSCM".equals(scm.getClass().getName())) {
            return null;
        }
        String runVersion = null;
        Class[] noparams = new Class[]{};
        Class[] paramEnvVars = new Class[]{EnvVars.class};
        Method methodGetBranches = null;
        try {
            methodGetBranches = scm.getClass().getDeclaredMethod("getBranches", noparams);
        }
        catch (Exception x) {
            methodGetBranches = null;
        }
        if (methodGetBranches != null) {
            Object branchList = null;
            try {
                branchList = methodGetBranches.invoke((Object)scm, new Object[0]);
            }
            catch (Exception x) {
                branchList = null;
            }
            if (branchList != null && branchList instanceof List) {
                Object branch0 = ((List)branchList).get(0);
                if (branch0 != null && "hudson.plugins.git.BranchSpec".equals(branch0.getClass().getName())) {
                    Method methodGetExpandedName = null;
                    try {
                        methodGetExpandedName = branch0.getClass().getDeclaredMethod("getExpandedName", paramEnvVars);
                    }
                    catch (Exception x) {
                        methodGetExpandedName = null;
                    }
                    if (methodGetExpandedName != null) {
                        Object expandedBranchName = null;
                        try {
                            expandedBranchName = methodGetExpandedName.invoke(branch0, run.getEnvironment(listener));
                        }
                        catch (Exception x) {
                            expandedBranchName = null;
                        }
                        if (expandedBranchName != null) {
                            runVersion = expandedBranchName.toString();
                        }
                    } else if (logger != null) {
                        logger.println("defaultedVersion(): did not find method BranchSpec.getExpandedName()");
                    }
                    if (runVersion == null || "".equals(runVersion)) {
                        runVersion = branch0.toString();
                    }
                } else if (logger != null) {
                    logger.println("defaultedVersion(): list of branches did not return a BranchSpec class instance, but " + (branch0 == null ? "null" : branch0.getClass().getName()));
                }
            } else if (logger != null) {
                logger.println("defaultedVersion(): getBranches() did not return a list of branches: " + (branchList == null ? "null" : branchList.getClass().getName()));
            }
        } else if (logger != null) {
            logger.println("defaultedVersion(): did not find method GitSCM.getBranches()");
        }
        if (runVersion != null) {
            runVersion = runVersion.replaceFirst("^\\*/", "");
            if (logger != null) {
                logger.println("defaultedVersion(): Discovered runVersion '" + runVersion + "' in GitSCM source of the pipeline");
            }
        }
        return runVersion;
    }

    private String extractDefaultedVersionSCMFS(@NonNull SCM scm, @NonNull Run<?, ?> run, @NonNull TaskListener listener, PrintStream logger) {
        SCMFileSystem fs;
        String runVersion;
        block7: {
            runVersion = null;
            Job runParent = run.getParent();
            try {
                fs = SCMFileSystem.of((Item)runParent, (SCM)scm);
                if (fs == null && logger != null) {
                    logger.println("defaultedVersion(): got no SCMFileSystem: method of() returned null");
                }
            }
            catch (Exception x) {
                fs = null;
                if (logger == null) break block7;
                logger.println("defaultedVersion(): failed to get SCMFileSystem: " + x.getMessage());
            }
        }
        if (fs == null) {
            return null;
        }
        SCMRevision rev = fs.getRevision();
        if (rev == null) {
            if (logger != null) {
                logger.println("defaultedVersion(): got no SCMRevision from SCMFileSystem");
            }
            return null;
        }
        SCMHead head = rev.getHead();
        if (logger != null) {
            logger.println("defaultedVersion(): got SCMHead of SCMRevision from SCMFileSystem: name='" + head.getName() + "' toString='" + head.toString() + "'");
        }
        return runVersion;
    }

    private String extractDefaultedVersionSCM(@NonNull SCM scm, @NonNull Run<?, ?> run, @NonNull TaskListener listener, PrintStream logger) {
        String runVersion = null;
        if (logger != null) {
            logger.println("defaultedVersion(): inspecting first listed SCM: " + scm.toString());
        }
        if ((runVersion = this.extractDefaultedVersionSCMFS(scm, run, listener, logger)) == null) {
            runVersion = this.extractDefaultedVersionGitSCM(scm, run, listener, logger);
        }
        if (runVersion == null && logger != null) {
            logger.println("defaultedVersion(): the first listed SCM was not of currently supported class with recognized branch support: " + scm.getClass().getName());
        }
        return runVersion;
    }

    private String defaultedVersionSCM(@NonNull Run<?, ?> run, @NonNull TaskListener listener, PrintStream logger) {
        String runVersion;
        SCM scm0;
        block19: {
            block20: {
                Collection fdscms;
                FlowDefinition fd;
                block21: {
                    scm0 = null;
                    runVersion = null;
                    Job runParent = run.getParent();
                    if (runParent == null || !(runParent instanceof WorkflowJob)) break block20;
                    if (logger != null) {
                        logger.println("defaultedVersion(): inspecting WorkflowJob for a FlowDefinition");
                    }
                    if ((fd = ((WorkflowJob)runParent).getDefinition()) == null) break block20;
                    if (fd instanceof CpsScmFlowDefinition) {
                        CpsScmFlowDefinition csfd = (CpsScmFlowDefinition)fd;
                        if (logger != null) {
                            logger.println("defaultedVersion(): inspecting CpsScmFlowDefinition '" + csfd.getClass().getName() + "' for an SCM it might use (with" + (csfd.isLightweight() ? "" : "out") + " lightweight checkout)");
                        }
                        if ((scm0 = csfd.getScm()) == null) {
                            if (logger != null) {
                                logger.println("defaultedVersion(): CpsScmFlowDefinition '" + csfd.getClass().getName() + "' is not associated with an SCM");
                            }
                        } else if (!this.isDefaultedVersionSCMSupported(scm0)) {
                            if (logger != null) {
                                logger.println("defaultedVersion(): CpsScmFlowDefinition '" + csfd.getClass().getName() + "' is associated with an SCM class we can not query for branches: " + scm0.toString());
                            }
                            scm0 = null;
                        }
                    }
                    if (scm0 != null) break block20;
                    fdscms = fd.getSCMs();
                    if (!fdscms.isEmpty()) break block21;
                    if (logger == null) break block20;
                    logger.println("defaultedVersion(): generic FlowDefinition '" + fd.getClass().getName() + "' is not associated with any SCMs");
                    break block20;
                }
                if (logger != null) {
                    logger.println("defaultedVersion(): inspecting generic FlowDefinition '" + fd.getClass().getName() + "' for SCMs it might use");
                }
                for (SCM scmN : fdscms) {
                    if (logger != null) {
                        logger.println("defaultedVersion(): inspecting SCM '" + scmN.getClass().getName() + "': " + scmN.toString());
                    }
                    if (!this.isDefaultedVersionSCMSupported(scmN)) continue;
                    scm0 = scmN;
                    break;
                }
            }
            if (scm0 == null && run instanceof WorkflowRun) {
                if (logger != null) {
                    logger.println("defaultedVersion(): inspecting WorkflowRun");
                }
                try {
                    WorkflowRun wfRun = (WorkflowRun)run;
                    List wfrscms = wfRun.getSCMs();
                    if (wfrscms.isEmpty()) {
                        if (logger != null) {
                            logger.println("defaultedVersion(): WorkflowRun '" + wfRun.getClass().getName() + "' is not associated with any SCMs");
                        }
                    } else {
                        scm0 = (SCM)wfRun.getSCMs().get(0);
                    }
                }
                catch (Exception x) {
                    if (logger == null) break block19;
                    logger.println("defaultedVersion(): Did not get first listed SCM: " + x.getMessage());
                }
            }
        }
        if (scm0 != null) {
            runVersion = this.extractDefaultedVersionSCM(scm0, run, listener, logger);
        }
        return runVersion;
    }

    @NonNull
    String defaultedVersion(@CheckForNull String version) throws AbortException {
        return this.defaultedVersion(version, null, null);
    }

    @NonNull
    String defaultedVersion(@CheckForNull String version, Run<?, ?> run, TaskListener listener) throws AbortException {
        PrintStream logger = null;
        if (this.traceDefaultedVersion && listener != null) {
            logger = listener.getLogger();
        }
        if (logger != null) {
            logger.println("defaultedVersion(): Resolving '" + version + "'");
        }
        if (version == null) {
            if (this.defaultVersion == null) {
                throw new AbortException("No version specified for library " + this.name);
            }
            return this.defaultVersion;
        }
        if (!(!this.allowVersionOverride || "${BRANCH_NAME}".equals(version) || version.startsWith("${env.") && version.endsWith("}"))) {
            return version;
        }
        if (this.allowVersionEnvvar && version.startsWith("${env.") && version.endsWith("}")) {
            Job runParent2;
            String envVersion;
            String runVersion;
            block66: {
                runVersion = null;
                envVersion = version.substring(6, version.length() - 1);
                runParent2 = null;
                if (run != null && listener != null) {
                    try {
                        runParent2 = run.getParent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (logger != null) {
                    logger.println("defaultedVersion(): Resolving envvar '" + envVersion + "'; " + (runParent2 == null ? "without" : "have") + " a runParent object");
                }
                if (runParent2 != null) {
                    try {
                        runVersion = run.getEnvironment(listener).get(envVersion, null);
                        if (logger == null) break block66;
                        if (runVersion != null) {
                            logger.println("defaultedVersion(): Resolved envvar " + envVersion + "='" + runVersion + "'");
                            break block66;
                        }
                        logger.println("defaultedVersion(): Did not resolve envvar " + envVersion + ": not in env");
                    }
                    catch (Exception x) {
                        runVersion = null;
                        if (logger != null) {
                            logger.println("defaultedVersion(): Did not resolve envvar " + envVersion + ": " + x.getMessage());
                        }
                        break block66;
                    }
                }
                if (logger != null) {
                    logger.println("defaultedVersion(): Trying to default: without a runParent we can't validateVersion() anyway");
                }
            }
            if (runParent2 == null || runVersion == null || "".equals(runVersion)) {
                if (logger != null) {
                    logger.println("defaultedVersion(): Trying to default: runVersion is " + (runVersion == null ? "null" : ("".equals(runVersion) ? "empty" : runVersion)));
                }
                if (this.defaultVersion == null) {
                    throw new AbortException("No version specified for library " + this.name);
                }
                return this.defaultVersion;
            }
            if (this.retriever != null) {
                FormValidation fv;
                if (logger != null) {
                    logger.println("defaultedVersion(): Trying to validate runVersion: " + runVersion);
                }
                if ((fv = this.retriever.validateVersion(this.name, runVersion, (Item)runParent2)) != null && fv.kind == FormValidation.Kind.OK) {
                    return runVersion;
                }
            }
            if (logger != null) {
                logger.println("defaultedVersion(): Trying to default: could not resolve runVersion which is " + ("".equals(runVersion) ? "empty" : runVersion));
            }
            if (this.defaultVersion == null) {
                throw new AbortException(envVersion + " version " + runVersion + " was not found, and no default version specified, for library " + this.name);
            }
            return this.defaultVersion;
        }
        if (this.allowBRANCH_NAME && "${BRANCH_NAME}".equals(version)) {
            String runVersion = null;
            Job runParent = null;
            if (run != null && listener != null) {
                try {
                    runParent = run.getParent();
                }
                catch (Exception runParent2) {
                    // empty catch block
                }
            }
            if (logger != null) {
                logger.println("defaultedVersion(): Resolving BRANCH_NAME; " + (runParent == null ? "without" : "have") + " a runParent object");
            }
            if (runParent != null) {
                block68: {
                    block67: {
                        if (runParent instanceof WorkflowJob) {
                            BranchJobProperty property;
                            if (logger != null) {
                                logger.println("defaultedVersion(): inspecting WorkflowJob for BranchJobProperty");
                            }
                            if ((property = (BranchJobProperty)((WorkflowJob)runParent).getProperty(BranchJobProperty.class)) != null) {
                                try {
                                    runVersion = property.getBranch().getName();
                                    if (logger != null) {
                                        logger.println("defaultedVersion(): WorkflowJob BranchJobProperty refers to " + runVersion);
                                    }
                                    break block67;
                                }
                                catch (Exception x) {
                                    runVersion = null;
                                    if (logger != null) {
                                        logger.println("defaultedVersion(): WorkflowJob BranchJobProperty does not refer to a runVersion: " + x.getMessage());
                                    }
                                    break block67;
                                }
                            }
                            if (logger != null) {
                                logger.println("defaultedVersion(): WorkflowJob is not associated with a BranchJobProperty");
                            }
                        }
                    }
                    if (runVersion == null) {
                        try {
                            runVersion = run.getEnvironment(listener).get("BRANCH_NAME", null);
                            if (logger != null) {
                                if (runVersion != null) {
                                    logger.println("defaultedVersion(): Resolved envvar BRANCH_NAME='" + runVersion + "'");
                                } else {
                                    logger.println("defaultedVersion(): Did not resolve envvar BRANCH_NAME: not in env");
                                }
                            }
                        }
                        catch (Exception x) {
                            runVersion = null;
                            if (logger == null) break block68;
                            logger.println("defaultedVersion(): Did not resolve envvar BRANCH_NAME: " + x.getMessage());
                        }
                    }
                }
                if (runVersion == null) {
                    runVersion = this.defaultedVersionSCM(run, listener, logger);
                }
            } else if (logger != null) {
                logger.println("defaultedVersion(): Trying to default: without a runParent we can't validateVersion() anyway");
            }
            if (runParent == null || runVersion == null || "".equals(runVersion)) {
                if (logger != null) {
                    logger.println("defaultedVersion(): Trying to default: runVersion is " + (runVersion == null ? "null" : ("".equals(runVersion) ? "empty" : runVersion)));
                }
                if (this.defaultVersion == null) {
                    throw new AbortException("No version specified for library " + this.name);
                }
                return this.defaultVersion;
            }
            if (this.retriever != null) {
                FormValidation fv;
                if (logger != null) {
                    logger.println("defaultedVersion(): Trying to validate runVersion: " + runVersion);
                }
                if ((fv = this.retriever.validateVersion(this.name, runVersion, (Item)runParent)) != null && fv.kind == FormValidation.Kind.OK) {
                    return runVersion;
                }
                if (runVersion.startsWith("PR-") && this.allowBRANCH_NAME_PR) {
                    try {
                        runVersion = run.getEnvironment(listener).get("CHANGE_BRANCH", null);
                    }
                    catch (Exception x) {
                        runVersion = null;
                    }
                    if (runVersion != null && !"".equals(runVersion)) {
                        if (logger != null) {
                            logger.println("defaultedVersion(): Trying to validate CHANGE_BRANCH: " + runVersion);
                        }
                        if ((fv = this.retriever.validateVersion(this.name, runVersion, (Item)runParent)) != null && fv.kind == FormValidation.Kind.OK) {
                            return runVersion;
                        }
                    }
                    try {
                        runVersion = run.getEnvironment(listener).get("CHANGE_TARGET", null);
                    }
                    catch (Exception x) {
                        runVersion = null;
                    }
                    if (runVersion != null && !"".equals(runVersion)) {
                        if (logger != null) {
                            logger.println("defaultedVersion(): Trying to validate CHANGE_TARGET: " + runVersion);
                        }
                        if ((fv = this.retriever.validateVersion(this.name, runVersion, (Item)runParent)) != null && fv.kind == FormValidation.Kind.OK) {
                            return runVersion;
                        }
                    }
                }
            }
            if (logger != null) {
                logger.println("defaultedVersion(): Trying to default: could not resolve runVersion which is " + (runVersion == null ? "null" : ("".equals(runVersion) ? "empty" : runVersion)));
            }
            if (this.defaultVersion == null) {
                throw new AbortException("BRANCH_NAME version " + runVersion + " was not found, and no default version specified, for library " + this.name);
            }
            return this.defaultVersion;
        }
        throw new AbortException("Version override not permitted for library " + this.name);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<LibraryConfiguration> {
        @Restricted(value={NoExternalUse.class})
        public Collection<LibraryRetrieverDescriptor> getRetrieverDescriptors() {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            Item it = req != null ? (Item)req.findAncestorObject(Item.class) : null;
            return DescriptorVisibilityFilter.apply((Object)(it != null ? it : Jenkins.get()), (Iterable)ExtensionList.lookup(LibraryRetrieverDescriptor.class));
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (name.isEmpty()) {
                return FormValidation.error((String)"You must enter a name.");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckDefaultVersion(@AncestorInPath Item context, @QueryParameter String defaultVersion, @QueryParameter boolean implicit, @QueryParameter boolean allowVersionOverride, @QueryParameter boolean allowVersionEnvvar, @QueryParameter boolean allowBRANCH_NAME, @QueryParameter boolean allowBRANCH_NAME_PR, @QueryParameter String name) {
            if (defaultVersion.isEmpty()) {
                if (implicit) {
                    return FormValidation.error((String)"If you load a library implicitly, you must specify a default version.");
                }
                if (allowBRANCH_NAME) {
                    return FormValidation.error((String)"If you allow use of literal '${BRANCH_NAME}' for overriding a default version, you must define that version as fallback.");
                }
                if (allowVersionEnvvar) {
                    return FormValidation.error((String)"If you allow use of literal '${env.VARNAME}' pattern for overriding a default version, you must define that version as fallback.");
                }
                if (!allowVersionOverride) {
                    return FormValidation.error((String)"If you deny overriding a default version, you must define that version.");
                }
                if (allowBRANCH_NAME_PR) {
                    return FormValidation.warning((String)"This setting has no effect when you do not allow use of literal '${BRANCH_NAME}' for overriding a default version");
                }
                return FormValidation.ok();
            }
            if ("${BRANCH_NAME}".equals(defaultVersion)) {
                if (!allowBRANCH_NAME) {
                    return FormValidation.error((String)"Use of literal '${BRANCH_NAME}' not allowed in this configuration.");
                }
                String msg = "Cannot validate default version: literal '${BRANCH_NAME}' is reserved for pipeline files from SCM";
                if (implicit) {
                    return FormValidation.warning((String)msg);
                }
                return FormValidation.error((String)msg);
            }
            if (defaultVersion.startsWith("${env.") && defaultVersion.endsWith("}")) {
                if (!allowVersionEnvvar) {
                    return FormValidation.error((String)"Use of literal '${env.VARNAME}' pattern not allowed in this configuration.");
                }
                String msg = "Cannot set default version to literal '${env.VARNAME}' pattern";
                return FormValidation.error((String)msg);
            }
            for (LibraryResolver resolver : ExtensionList.lookup(LibraryResolver.class)) {
                for (LibraryConfiguration config : resolver.fromConfiguration(Stapler.getCurrentRequest2())) {
                    if (!config.getName().equals(name)) continue;
                    return config.getRetriever().validateVersion(name, defaultVersion, context);
                }
            }
            return FormValidation.ok((String)"Cannot validate default version until after saving and reconfiguring.");
        }
    }
}

