// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.libs;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code GlobalUntrustedLibraries.DisplayName}: {@code Global

     * Untrusted Pipeline Libraries}.
     * 
     * @return
     *     {@code Global Untrusted Pipeline Libraries}
     */
    public static String GlobalUntrustedLibraries_DisplayName() {
        return holder.format("GlobalUntrustedLibraries.DisplayName");
    }

    /**
     * Key {@code GlobalUntrustedLibraries.DisplayName}: {@code Global

     * Untrusted Pipeline Libraries}.
     * 
     * @return
     *     {@code Global Untrusted Pipeline Libraries}
     */
    public static Localizable _GlobalUntrustedLibraries_DisplayName() {
        return new Localizable(holder, "GlobalUntrustedLibraries.DisplayName");
    }

    /**
     * Key {@code LibraryDecorator.could_not_find_any_definition_of_librari}:

     * {@code Could not find any definition of libraries {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find any definition of libraries {0}}
     */
    public static String LibraryDecorator_could_not_find_any_definition_of_librari(Object arg0) {
        return holder.format("LibraryDecorator.could_not_find_any_definition_of_librari", arg0);
    }

    /**
     * Key {@code LibraryDecorator.could_not_find_any_definition_of_librari}:

     * {@code Could not find any definition of libraries {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not find any definition of libraries {0}}
     */
    public static Localizable _LibraryDecorator_could_not_find_any_definition_of_librari(Object arg0) {
        return new Localizable(holder, "LibraryDecorator.could_not_find_any_definition_of_librari", arg0);
    }

    /**
     * Key {@code GlobalLibraries.DisplayName}: {@code Global Trusted

     * Pipeline Libraries}.
     * 
     * @return
     *     {@code Global Trusted Pipeline Libraries}
     */
    public static String GlobalLibraries_DisplayName() {
        return holder.format("GlobalLibraries.DisplayName");
    }

    /**
     * Key {@code GlobalLibraries.DisplayName}: {@code Global Trusted

     * Pipeline Libraries}.
     * 
     * @return
     *     {@code Global Trusted Pipeline Libraries}
     */
    public static Localizable _GlobalLibraries_DisplayName() {
        return new Localizable(holder, "GlobalLibraries.DisplayName");
    }

    /**
     * Key {@code ResourceStep.no_such_library_resource_could_be_found_}:

     * {@code No such library resource {0} could be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such library resource {0} could be found.}
     */
    public static String ResourceStep_no_such_library_resource_could_be_found_(Object arg0) {
        return holder.format("ResourceStep.no_such_library_resource_could_be_found_", arg0);
    }

    /**
     * Key {@code ResourceStep.no_such_library_resource_could_be_found_}:

     * {@code No such library resource {0} could be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such library resource {0} could be found.}
     */
    public static Localizable _ResourceStep_no_such_library_resource_could_be_found_(Object arg0) {
        return new Localizable(holder, "ResourceStep.no_such_library_resource_could_be_found_", arg0);
    }

    /**
     * Key {@code GlobalLibraries.Description}: {@code Sharable libraries

     * available to any Pipeline jobs running on this system. These libraries

     * will be trusted, meaning they run without “sandbox” restrictions and

     * may use <code>@Grab</code>.}.
     * 
     * @return
     *     {@code Sharable libraries available to any Pipeline jobs running on

     *     this system. These libraries will be trusted, meaning they run without

     *     “sandbox” restrictions and may use <code>@Grab</code>.}
     */
    public static String GlobalLibraries_Description() {
        return holder.format("GlobalLibraries.Description");
    }

    /**
     * Key {@code GlobalLibraries.Description}: {@code Sharable libraries

     * available to any Pipeline jobs running on this system. These libraries

     * will be trusted, meaning they run without “sandbox” restrictions and

     * may use <code>@Grab</code>.}.
     * 
     * @return
     *     {@code Sharable libraries available to any Pipeline jobs running on

     *     this system. These libraries will be trusted, meaning they run without

     *     “sandbox” restrictions and may use <code>@Grab</code>.}
     */
    public static Localizable _GlobalLibraries_Description() {
        return new Localizable(holder, "GlobalLibraries.Description");
    }

    /**
     * Key {@code GlobalUntrustedLibraries.Description}: {@code Sharable

     * libraries available to any Pipeline jobs running on this system. These

     * libraries will be untrusted, meaning they run with “sandbox”

     * restrictions and cannot use <code>@Grab</code>.}.
     * 
     * @return
     *     {@code Sharable libraries available to any Pipeline jobs running on

     *     this system. These libraries will be untrusted, meaning they run with

     *     “sandbox” restrictions and cannot use <code>@Grab</code>.}
     */
    public static String GlobalUntrustedLibraries_Description() {
        return holder.format("GlobalUntrustedLibraries.Description");
    }

    /**
     * Key {@code GlobalUntrustedLibraries.Description}: {@code Sharable

     * libraries available to any Pipeline jobs running on this system. These

     * libraries will be untrusted, meaning they run with “sandbox”

     * restrictions and cannot use <code>@Grab</code>.}.
     * 
     * @return
     *     {@code Sharable libraries available to any Pipeline jobs running on

     *     this system. These libraries will be untrusted, meaning they run with

     *     “sandbox” restrictions and cannot use <code>@Grab</code>.}
     */
    public static Localizable _GlobalUntrustedLibraries_Description() {
        return new Localizable(holder, "GlobalUntrustedLibraries.Description");
    }

    /**
     * Key {@code ResourceStep.library_resource_ambiguous_among_librari}:

     * {@code Library resource {0} ambiguous among libraries {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Library resource {0} ambiguous among libraries {1}}
     */
    public static String ResourceStep_library_resource_ambiguous_among_librari(Object arg0, Object arg1) {
        return holder.format("ResourceStep.library_resource_ambiguous_among_librari", arg0, arg1);
    }

    /**
     * Key {@code ResourceStep.library_resource_ambiguous_among_librari}:

     * {@code Library resource {0} ambiguous among libraries {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Library resource {0} ambiguous among libraries {1}}
     */
    public static Localizable _ResourceStep_library_resource_ambiguous_among_librari(Object arg0, Object arg1) {
        return new Localizable(holder, "ResourceStep.library_resource_ambiguous_among_librari", arg0, arg1);
    }

    /**
     * Key {@code SCMSourceRetriever.library_path_no_double_dot}: {@code

     * Library path may not contain ".."}.
     * 
     * @return
     *     {@code Library path may not contain ".."}
     */
    public static String SCMSourceRetriever_library_path_no_double_dot() {
        return holder.format("SCMSourceRetriever.library_path_no_double_dot");
    }

    /**
     * Key {@code SCMSourceRetriever.library_path_no_double_dot}: {@code

     * Library path may not contain ".."}.
     * 
     * @return
     *     {@code Library path may not contain ".."}
     */
    public static Localizable _SCMSourceRetriever_library_path_no_double_dot() {
        return new Localizable(holder, "SCMSourceRetriever.library_path_no_double_dot");
    }

}
