/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import jenkins.security.HMACConfidentialKey;
import org.jenkinsci.plugins.workflow.libs.LibraryCachingConfiguration;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class LibraryRecord {
    private static final HMACConfidentialKey DIRECTORY_NAME_KEY = new HMACConfidentialKey(LibraryRecord.class, "directoryName", 32);
    private static final String ASCII_UNIT_SEPARATOR = String.valueOf('\u001f');
    final String name;
    final String version;
    final Set<String> variables = new TreeSet<String>();
    final boolean trusted;
    final boolean changelog;
    final LibraryCachingConfiguration cachingConfiguration;
    private String logString;
    private String directoryName;

    LibraryRecord(String name, String version, boolean trusted, boolean changelog, LibraryCachingConfiguration cachingConfiguration, String source, @CheckForNull String libraryPath) {
        this.name = name;
        this.version = version;
        this.trusted = trusted;
        this.changelog = changelog;
        this.cachingConfiguration = cachingConfiguration;
        this.logString = this.name + "@" + this.version;
        if (this.onTheRoadToNowhere(libraryPath)) {
            this.directoryName = LibraryRecord.directoryNameFor(name, version, String.valueOf(trusted), source);
        } else {
            this.directoryName = LibraryRecord.directoryNameFor(name, version, String.valueOf(trusted), source, libraryPath);
            this.logString = this.logString + ":" + libraryPath;
        }
    }

    private boolean onTheRoadToNowhere(@CheckForNull String libraryPath) {
        if (libraryPath == null) {
            return true;
        }
        String currentDir = Paths.get("", new String[0]).toAbsolutePath().normalize().toString();
        String libraryDir = Paths.get(libraryPath, new String[0]).toAbsolutePath().normalize().toString();
        return currentDir.equals(libraryDir);
    }

    @Exported
    public String getName() {
        return this.name;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getLogString() {
        return this.logString;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public Set<String> getVariables() {
        return Collections.unmodifiableSet(this.variables);
    }

    @Exported
    public boolean isTrusted() {
        return this.trusted;
    }

    @Exported
    public boolean isChangelog() {
        return this.changelog;
    }

    public String toString() {
        String cachingConfigurationStr = this.cachingConfiguration != null ? this.cachingConfiguration.toString() : "null";
        return "LibraryRecord{name=" + this.name + ", version=" + this.version + ", variables=" + String.valueOf(this.variables) + ", trusted=" + this.trusted + ", changelog=" + this.changelog + ", cachingConfiguration=" + cachingConfigurationStr + ", directoryName=" + this.directoryName + "}";
    }

    private Object readResolve() {
        if (this.directoryName == null) {
            this.directoryName = this.name;
        }
        return this;
    }

    public static String directoryNameFor(String ... data) {
        for (String datum : data) {
            if (!datum.contains(ASCII_UNIT_SEPARATOR)) continue;
            throw new IllegalStateException("Unable to create directory name due to control character in " + datum);
        }
        return DIRECTORY_NAME_KEY.mac(String.join((CharSequence)ASCII_UNIT_SEPARATOR, data));
    }
}

