/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jenkins.util.SystemProperties;
import org.jenkinsci.plugins.workflow.libs.LibraryAdder;
import org.jenkinsci.plugins.workflow.libs.LibraryCachingConfiguration;

@Extension
public class LibraryCachingCleanup
extends AsyncPeriodicWork {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="non-final for script console access")
    public static int EXPIRE_AFTER_READ_DAYS = SystemProperties.getInteger((String)(LibraryCachingCleanup.class.getName() + ".EXPIRE_AFTER_READ_DAYS"), (Integer)7);

    public LibraryCachingCleanup() {
        super("LibraryCachingCleanup");
    }

    public long getRecurrencePeriod() {
        return TimeUnit.HOURS.toMillis(12L);
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        FilePath globalCacheDir = LibraryCachingConfiguration.getGlobalLibrariesCacheDir();
        block0: for (FilePath library : globalCacheDir.list()) {
            if (this.removeIfExpiredCacheDirectory(library)) continue;
            for (FilePath version : library.list()) {
                if (!version.child("last_read").exists()) continue;
                library.deleteRecursive();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeIfExpiredCacheDirectory(FilePath library) throws IOException, InterruptedException {
        FilePath lastReadFile = new FilePath(library, "last_read");
        if (lastReadFile.exists()) {
            ReentrantReadWriteLock retrieveLock = LibraryAdder.getReadWriteLockFor(library.getName());
            retrieveLock.writeLock().lockInterruptibly();
            try {
                if (System.currentTimeMillis() - lastReadFile.lastModified() > TimeUnit.DAYS.toMillis(EXPIRE_AFTER_READ_DAYS)) {
                    library.deleteRecursive();
                    library.withSuffix("-name.txt").delete();
                }
            }
            finally {
                retrieveLock.writeLock().unlock();
            }
            return true;
        }
        return false;
    }
}

