/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.analysis.TimingInfo;
import io.jenkins.plugins.pipelinegraphview.utils.AbstractPipelineNode;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import java.util.List;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;

public class PipelineStage
extends AbstractPipelineNode {
    final List<PipelineStage> children;
    private final String seqContainerName;
    private final PipelineStage nextSibling;
    private final boolean sequential;
    final boolean synthetic;
    private final boolean placeholder;
    final String agent;
    private final String url;

    public PipelineStage(String id, String name, List<PipelineStage> children, PipelineState state, String type, String title, String seqContainerName, PipelineStage nextSibling, boolean sequential, boolean synthetic, boolean placeholder, TimingInfo timingInfo, String agent, String runUrl) {
        super(id, name, state, type, title, timingInfo);
        this.children = children;
        this.seqContainerName = seqContainerName;
        this.nextSibling = nextSibling;
        this.sequential = sequential;
        this.synthetic = synthetic;
        this.placeholder = placeholder;
        this.agent = agent;
        this.url = "/" + runUrl + "stages?selected-node=" + id;
    }

    public static class PipelineStageJsonProcessor
    extends AbstractPipelineNode.AbstractPipelineNodeJsonProcessor {
        public static void configure(JsonConfig config) {
            PipelineStageJsonProcessor.baseConfigure(config);
            config.registerJsonBeanProcessor(PipelineStage.class, (JsonBeanProcessor)new PipelineStageJsonProcessor());
        }

        public JSONObject processBean(Object bean, JsonConfig config) {
            if (!(bean instanceof PipelineStage)) {
                return null;
            }
            PipelineStage stage = (PipelineStage)bean;
            JSONObject json = this.create(stage, config);
            json.element("children", stage.children, config);
            json.element("seqContainerName", (Object)stage.seqContainerName);
            json.element("nextSibling", (Object)stage.nextSibling, config);
            json.element("isSequential", stage.sequential);
            json.element("synthetic", stage.synthetic);
            json.element("placeholder", stage.placeholder);
            json.element("agent", (Object)stage.agent);
            json.element("url", (Object)stage.url);
            return json;
        }
    }
}

