/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.multipipelinegraphview;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.multipipelinegraphview.PipelineRun;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class EtagBuilder {
    private static final EtagProducer NOOP = new EtagProducer.NoopEtagProducer();
    private EtagProducer producer = new EtagProducer.ValidEtagProducer();
    private boolean computed = false;

    public EtagBuilder add(PipelineRun run) {
        this.checkAlreadyComputed();
        if (run.isBuilding()) {
            this.producer = NOOP;
        } else {
            this.producer.consume(run);
        }
        return this;
    }

    @CheckForNull
    public String getEtag() {
        this.checkAlreadyComputed();
        this.computed = true;
        return this.producer.etag();
    }

    private void checkAlreadyComputed() {
        if (this.computed) {
            throw new IllegalStateException("getEtag() already called");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface EtagProducer {
        public void consume(@NonNull PipelineRun var1);

        @CheckForNull
        public String etag();

        public static final class NoopEtagProducer
        implements EtagProducer {
            private NoopEtagProducer() {
            }

            @Override
            public void consume(@NonNull PipelineRun run) {
            }

            @Override
            public String etag() {
                return null;
            }
        }

        public static final class ValidEtagProducer
        implements EtagProducer {
            private final MessageDigest digest;

            ValidEtagProducer() {
                try {
                    this.digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void consume(@NonNull PipelineRun run) {
                this.digest.update(run.etag().getBytes(StandardCharsets.UTF_8));
                this.digest.update((byte)0);
            }

            @Override
            public String etag() {
                return "\"" + Base64.getEncoder().encodeToString(this.digest.digest()) + "\"";
            }
        }
    }
}

