/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.analysis.TimingInfo;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;

public class AbstractPipelineNode {
    final String name;
    final PipelineState state;
    final String type;
    final String title;
    public final String id;
    private final long pauseDurationMillis;
    private final long totalDurationMillis;
    final TimingInfo timingInfo;

    public AbstractPipelineNode(String id, String name, PipelineState state, String type, String title, TimingInfo timingInfo) {
        this.id = id;
        this.name = name;
        this.state = state;
        this.type = type;
        this.title = title;
        this.timingInfo = timingInfo;
        this.pauseDurationMillis = timingInfo.getPauseDurationMillis();
        this.totalDurationMillis = timingInfo.getTotalDurationMillis();
    }

    public long getStartTimeMillis() {
        return this.timingInfo.getStartTimeMillis();
    }

    public Long getTotalDurationMillis() {
        return this.state.isInProgress() ? null : Long.valueOf(this.totalDurationMillis);
    }

    static abstract class AbstractPipelineNodeJsonProcessor
    implements JsonBeanProcessor {
        AbstractPipelineNodeJsonProcessor() {
        }

        protected static void baseConfigure(JsonConfig config) {
            config.registerJsonValueProcessor(PipelineState.class, (JsonValueProcessor)new PipelineState.PipelineStateJsonProcessor());
        }

        protected JSONObject create(AbstractPipelineNode node, JsonConfig config) {
            JSONObject json = new JSONObject();
            json.element("id", (Object)node.id);
            json.element("name", (Object)node.name);
            json.element("state", (Object)node.state, config);
            json.element("type", (Object)node.type);
            json.element("title", (Object)node.title);
            json.element("pauseDurationMillis", node.pauseDurationMillis);
            json.element("startTimeMillis", node.getStartTimeMillis());
            json.element("totalDurationMillis", (Object)node.getTotalDurationMillis());
            return json;
        }
    }
}

