/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Action;
import hudson.model.Result;
import io.jenkins.plugins.pipelinegraphview.Messages;
import io.jenkins.plugins.pipelinegraphview.analysis.TimingInfo;
import io.jenkins.plugins.pipelinegraphview.steps.HideFromViewStep;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;

public class FlowNodeWrapper {
    private final FlowNode node;
    private final NodeRunStatus status;
    private final TimingInfo timingInfo;
    public final List<FlowNodeWrapper> edges = new ArrayList<FlowNodeWrapper>();
    public final NodeType type;
    private final String displayName;
    private final InputStep inputStep;
    private final WorkflowRun run;
    private String causeOfFailure;
    private List<FlowNodeWrapper> parents = new ArrayList<FlowNodeWrapper>();
    private ErrorAction blockErrorAction;
    private Collection<Action> pipelineActions;

    public boolean probablySameNode(@Nullable FlowNodeWrapper that) {
        if (that == null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (!this.displayName.equals(that.displayName)) {
            return false;
        }
        FlowNodeWrapper thisParent = this.getFirstParent();
        if (thisParent != null) {
            return thisParent.probablySameNode(that.getFirstParent());
        }
        return that.getFirstParent() == null;
    }

    public FlowNodeWrapper(@NonNull FlowNode node, @NonNull NodeRunStatus status, @NonNull TimingInfo timingInfo, @NonNull WorkflowRun run) {
        this(node, status, timingInfo, null, run, null);
    }

    public FlowNodeWrapper(@NonNull FlowNode node, @NonNull NodeRunStatus status, @NonNull TimingInfo timingInfo, @Nullable InputStep inputStep, @NonNull WorkflowRun run) {
        this(node, status, timingInfo, inputStep, run, null);
    }

    public FlowNodeWrapper(@NonNull FlowNode node, @NonNull NodeRunStatus status, @NonNull TimingInfo timingInfo, @Nullable InputStep inputStep, @NonNull WorkflowRun run, @Nullable NodeType type) {
        this.node = node;
        this.status = status;
        this.timingInfo = timingInfo;
        this.type = type == null ? FlowNodeWrapper.getNodeType(node) : type;
        this.displayName = PipelineNodeUtil.getDisplayName(node);
        this.inputStep = inputStep;
        this.run = run;
    }

    public WorkflowRun getRun() {
        return this.run;
    }

    @NonNull
    public String getDisplayName() {
        return switch (this.type.ordinal()) {
            case 2 -> Messages.FlowNodeWrapper_parallel();
            case 6 -> Messages.FlowNodeWrapper_noStage();
            default -> this.displayName;
        };
    }

    @CheckForNull
    public String getLabelDisplayName() {
        LabelAction labelAction = (LabelAction)this.node.getAction(LabelAction.class);
        if (labelAction != null) {
            return labelAction.getDisplayName();
        }
        return null;
    }

    private static NodeType getNodeType(FlowNode node) {
        if (PipelineNodeUtil.isStep(node)) {
            return NodeType.STEP;
        }
        if (PipelineNodeUtil.isStage(node)) {
            return NodeType.STAGE;
        }
        if (PipelineNodeUtil.isParallelBranch(node)) {
            return NodeType.PARALLEL;
        }
        if (PipelineNodeUtil.isParallelBlock(node)) {
            return NodeType.PARALLEL_BLOCK;
        }
        if (node instanceof StepStartNode) {
            return NodeType.STEPS_BLOCK;
        }
        if (node instanceof FlowStartNode) {
            return NodeType.PIPELINE_START;
        }
        if (PipelineNodeUtil.isUnhandledException(node)) {
            return NodeType.UNHANDLED_EXCEPTION;
        }
        throw new IllegalArgumentException(String.format("Unknown FlowNode %s, type: %s", node.getId(), node.getClass()));
    }

    @NonNull
    public NodeRunStatus getStatus() {
        if (this.hasBlockError()) {
            if (this.isBlockErrorInterruptedWithAbort()) {
                return new NodeRunStatus(BlueRun.BlueRunResult.ABORTED, BlueRun.BlueRunState.FINISHED);
            }
            return new NodeRunStatus(BlueRun.BlueRunResult.FAILURE, BlueRun.BlueRunState.FINISHED);
        }
        return this.status;
    }

    @NonNull
    public TimingInfo getTiming() {
        return this.timingInfo;
    }

    @NonNull
    public TimingInfo setTiming() {
        return this.timingInfo;
    }

    @NonNull
    public String getId() {
        return this.node.getId();
    }

    @NonNull
    public FlowNode getNode() {
        return this.node;
    }

    public NodeType getType() {
        return this.type;
    }

    public NodeType setType() {
        return this.type;
    }

    public void addEdge(FlowNodeWrapper edge) {
        this.edges.add(edge);
    }

    public void removeEdge(FlowNodeWrapper edge) {
        this.edges.remove(edge);
    }

    public void addEdges(List<FlowNodeWrapper> edges) {
        this.edges.addAll(edges);
    }

    public void addParent(FlowNodeWrapper parent) {
        this.parents.add(parent);
    }

    public void addParents(Collection<FlowNodeWrapper> parents) {
        this.parents.addAll(parents);
    }

    public void removeParent(FlowNodeWrapper parent) {
        this.parents.remove(parent);
    }

    @CheckForNull
    public FlowNodeWrapper getFirstParent() {
        return !this.parents.isEmpty() ? this.parents.get(0) : null;
    }

    @NonNull
    public List<FlowNodeWrapper> getParents() {
        return this.parents;
    }

    public String getCauseOfFailure() {
        return this.causeOfFailure;
    }

    public void setCauseOfFailure(String causeOfFailure) {
        this.causeOfFailure = causeOfFailure;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlowNodeWrapper)) {
            return false;
        }
        return this.node.equals((Object)((FlowNodeWrapper)obj).node);
    }

    @CheckForNull
    public InputStep getInputStep() {
        return this.inputStep;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[id=" + this.node.getId() + ",displayName=" + this.displayName + ",type=" + String.valueOf((Object)this.type) + "]";
    }

    boolean hasBlockError() {
        return this.blockErrorAction != null && this.blockErrorAction.getError() != null;
    }

    String blockError() {
        if (this.hasBlockError()) {
            return this.blockErrorAction.getError().getMessage();
        }
        return null;
    }

    @CheckForNull
    public String nodeError() {
        ErrorAction errorAction = this.node.getError();
        if (errorAction != null) {
            return errorAction.getError().getMessage();
        }
        return null;
    }

    boolean isBlockErrorInterruptedWithAbort() {
        Throwable error;
        if (this.hasBlockError() && (error = this.blockErrorAction.getError()) instanceof FlowInterruptedException) {
            FlowInterruptedException interrupted = (FlowInterruptedException)error;
            return interrupted.getResult().equals(Result.ABORTED);
        }
        return false;
    }

    boolean isLoggable() {
        return PipelineNodeUtil.isLoggable.apply((Object)this.node);
    }

    public void setBlockErrorAction(ErrorAction blockErrorAction) {
        this.blockErrorAction = blockErrorAction;
    }

    public static boolean isStart(FlowNode node) {
        return node instanceof BlockStartNode;
    }

    public static boolean isEnd(FlowNode node) {
        return node instanceof BlockEndNode;
    }

    public boolean isStep() {
        return this.type == NodeType.STEP;
    }

    public boolean isStepsBlock() {
        return this.type == NodeType.STEPS_BLOCK;
    }

    public <T extends Action> Collection<T> getPipelineActions(Class<T> clazz) {
        if (this.pipelineActions == null) {
            return Collections.emptyList();
        }
        ArrayList<Action> filtered = new ArrayList<Action>();
        for (Action a : this.pipelineActions) {
            if (!clazz.isInstance(a)) continue;
            filtered.add((Action)clazz.cast(a));
        }
        return filtered;
    }

    public Collection<Action> getPipelineActions() {
        return Collections.unmodifiableCollection(this.pipelineActions);
    }

    public void setPipelineActions(Collection<Action> pipelineActions) {
        this.pipelineActions = pipelineActions;
    }

    public String getArgumentsAsString() {
        return PipelineNodeUtil.getArgumentsAsString(this.node);
    }

    public boolean isSynthetic() {
        return PipelineNodeUtil.isSyntheticStage(this.node) || FlowNodeWrapper.getNodeType(this.node) == NodeType.PIPELINE_START;
    }

    public boolean isUnhandledException() {
        return PipelineNodeUtil.isUnhandledException(this.node);
    }

    public Map<String, Object> getFeatureFlags() {
        HashMap<String, Object> flags = new HashMap<String, Object>();
        for (BlockStartNode block : this.node.iterateEnclosingBlocks()) {
            StepStartNode stepStartNode;
            StepDescriptor descriptor;
            if (!(block instanceof StepStartNode) || (descriptor = (stepStartNode = (StepStartNode)block).getDescriptor()) == null || !HideFromViewStep.class.getName().equals(descriptor.getId())) continue;
            flags.put("hidden", Boolean.TRUE);
            break;
        }
        return flags;
    }

    public static int compareIds(String ida, String idb) {
        return Integer.compare(Integer.parseInt(ida), Integer.parseInt(idb));
    }

    public static String getNodeGraphviz(List<FlowNodeWrapper> nodes) {
        StringBuilder nodeMapStr = new StringBuilder("digraph G {").append(System.lineSeparator());
        for (FlowNodeWrapper node : nodes) {
            nodeMapStr.append(" ").append(node.getId());
            nodeMapStr.append(" [label=\"{id: ").append(node.getId());
            nodeMapStr.append(", name: ").append(node.getDisplayName());
            nodeMapStr.append(", type: ").append((Object)node.getType());
            nodeMapStr.append(", state: ").append((Object)node.getStatus().state);
            nodeMapStr.append(", result: ").append((Object)node.getStatus().result);
            nodeMapStr.append("}\"]").append(System.lineSeparator());
            for (FlowNodeWrapper parent : node.getParents()) {
                nodeMapStr.append("  ").append(node.getId()).append(" -> ").append(parent.getId()).append(System.lineSeparator());
            }
        }
        nodeMapStr.append("}");
        return nodeMapStr.toString();
    }

    public static enum NodeType {
        STAGE,
        PARALLEL,
        PARALLEL_BLOCK,
        STEP,
        STEPS_BLOCK,
        UNHANDLED_EXCEPTION,
        PIPELINE_START;

    }

    public static class NodeIdComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(String a, String b) {
            return FlowNodeWrapper.compareIds(a, b);
        }
    }

    public static class FlowNodeComparator
    implements Comparator<FlowNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(FlowNode a, FlowNode b) {
            return FlowNodeWrapper.compareIds(a.getId(), b.getId());
        }
    }

    public static class NodeComparator
    implements Comparator<FlowNodeWrapper>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(FlowNodeWrapper a, FlowNodeWrapper b) {
            return FlowNodeWrapper.compareIds(a.getId(), b.getId());
        }
    }
}

