/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.analysis.TimingInfo;
import io.jenkins.plugins.pipelinegraphview.utils.AbstractPipelineNode;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineInputStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import java.util.Map;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;

public class PipelineStep
extends AbstractPipelineNode {
    final String stageId;
    private final PipelineInputStep inputStep;
    private final Map<String, Object> flags;

    public PipelineStep(String id, String name, PipelineState state, String type, String title, String stageId, PipelineInputStep inputStep, TimingInfo timingInfo, Map<String, Object> flags) {
        super(id, name, state, type, title, timingInfo);
        this.stageId = stageId;
        this.inputStep = inputStep;
        this.flags = flags;
    }

    public Map<String, Object> getFlags() {
        return this.flags;
    }

    public static class PipelineStepJsonProcessor
    extends AbstractPipelineNode.AbstractPipelineNodeJsonProcessor {
        public static void configure(JsonConfig config) {
            PipelineStepJsonProcessor.baseConfigure(config);
            config.registerJsonBeanProcessor(PipelineStep.class, (JsonBeanProcessor)new PipelineStepJsonProcessor());
            PipelineInputStep.PipelineInputStepJsonProcessor.configure(config);
        }

        public JSONObject processBean(Object bean, JsonConfig jsonConfig) {
            if (!(bean instanceof PipelineStep)) {
                return null;
            }
            PipelineStep step = (PipelineStep)bean;
            JSONObject json = this.create(step, jsonConfig);
            json.element("stageId", (Object)step.stageId);
            if (step.inputStep != null) {
                json.element("inputStep", (Object)step.inputStep, jsonConfig);
            }
            json.element("flags", step.flags);
            return json;
        }
    }
}

