/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.utils.FeatureFlagValidator;

public class HiddenFlagValidator
implements FeatureFlagValidator {
    @Override
    @NonNull
    public String getFlagName() {
        return "hidden";
    }

    @Override
    @CheckForNull
    public Object validate(@NonNull String rawValue) {
        return "true".equals(rawValue) ? Boolean.TRUE : null;
    }

    @Override
    @NonNull
    public String getDescription() {
        return "Boolean flag: only 'true' is accepted. When set, marks the step as hidden.";
    }
}

