/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.utils.FeatureFlagValidator;
import io.jenkins.plugins.pipelinegraphview.utils.HiddenFlagValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FeatureFlagRegistry {
    private static final Map<String, FeatureFlagValidator> VALIDATORS = new HashMap<String, FeatureFlagValidator>();

    private static void register(@NonNull FeatureFlagValidator validator) {
        VALIDATORS.put(validator.getFlagName(), validator);
    }

    @CheckForNull
    public static FeatureFlagValidator getValidator(@NonNull String flagName) {
        return VALIDATORS.get(flagName);
    }

    @CheckForNull
    public static Object validateFlag(@NonNull String flagName, @NonNull String rawValue) {
        FeatureFlagValidator validator = FeatureFlagRegistry.getValidator(flagName);
        if (validator == null) {
            return null;
        }
        return validator.validate(rawValue);
    }

    @NonNull
    public static Set<String> getRegisteredFlags() {
        return Collections.unmodifiableSet(VALIDATORS.keySet());
    }

    public static boolean isRegistered(@NonNull String flagName) {
        return VALIDATORS.containsKey(flagName);
    }

    static {
        FeatureFlagRegistry.register(new HiddenFlagValidator());
    }
}

