/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.treescanner;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.treescanner.NodeRelationship;
import io.jenkins.plugins.pipelinegraphview.treescanner.ParallelBlockRelationship;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRelationshipFinder {
    private static final Logger logger = LoggerFactory.getLogger(NodeRelationshipFinder.class);
    private boolean isDebugEnabled = logger.isDebugEnabled();
    private LinkedHashMap<String, FlowNode> endNodes = new LinkedHashMap();
    private ArrayDeque<ArrayDeque<FlowNode>> lastSeenNodes = new ArrayDeque();
    private Map<String, ArrayDeque<FlowNode>> seenChildNodes = new LinkedHashMap<String, ArrayDeque<FlowNode>>();
    private ArrayDeque<NodeRelationship> pendingBranchRelationships = new ArrayDeque();
    private LinkedHashMap<String, NodeRelationship> relationships = new LinkedHashMap();

    @NonNull
    public Map<String, NodeRelationship> getNodeRelationships(@NonNull Collection<FlowNode> nodes) {
        if (this.isDebugEnabled) {
            logger.atDebug().addArgument(() -> nodes.stream().map(FlowNode::getId).collect(Collectors.joining(", "))).log("Original Ids: {}");
        }
        List<FlowNode> sorted = nodes.stream().sorted(new FlowNodeWrapper.FlowNodeComparator().reversed()).toList();
        if (this.isDebugEnabled) {
            logger.atDebug().addArgument(() -> sorted.stream().map(FlowNode::getId).collect(Collectors.joining(", "))).log("Sorted Ids: {}");
        }
        sorted.forEach(node -> {
            this.getRelationshipForNode((FlowNode)node);
            this.addSeenNodes((FlowNode)node);
        });
        return this.relationships;
    }

    private void getRelationshipForNode(@NonNull FlowNode node) {
        if (node instanceof StepAtomNode) {
            StepAtomNode atomNode = (StepAtomNode)node;
            this.addStepRelationship(atomNode);
        } else if (node instanceof BlockEndNode) {
            BlockEndNode endNode = (BlockEndNode)node;
            this.handleBlockEnd(endNode);
        } else {
            this.handleBlockStart(node);
        }
    }

    private void handleBlockStart(@NonNull FlowNode node) {
        if (FlowNodeWrapper.isStart(node)) {
            this.addBlockRelationship(node);
        } else {
            logger.debug("Why are we here?? {} - {}", (Object)node.getId(), node.getClass());
        }
    }

    private void addSeenNodes(FlowNode node) {
        String enclosingId = node.getEnclosingId();
        if (!this.seenChildNodes.containsKey(enclosingId)) {
            this.seenChildNodes.put(enclosingId, new ArrayDeque());
        }
        if (this.isDebugEnabled) {
            logger.debug("Adding {} to seenChildNodes {}", (Object)node.getId(), (Object)enclosingId);
        }
        this.seenChildNodes.get(enclosingId).push(node);
    }

    @CheckForNull
    private FlowNode getAfterNode(FlowNode node) {
        FlowNode after;
        BlockStartNode parentStartNode = this.getFirstEnclosingNode(node);
        ArrayDeque<FlowNode> laterSiblings = this.getProcessedChildren((FlowNode)parentStartNode);
        if (parentStartNode != null && laterSiblings.isEmpty()) {
            ArrayDeque<FlowNode> parentsLaterSiblings = this.getProcessedChildren((FlowNode)this.getFirstEnclosingNode((FlowNode)parentStartNode));
            FlowNode flowNode = after = parentsLaterSiblings.isEmpty() ? null : parentsLaterSiblings.peek();
            if (this.isDebugEnabled) {
                logger.debug(parentsLaterSiblings.toString());
            }
        } else {
            if (this.isDebugEnabled) {
                logger.debug(laterSiblings.toString());
            }
            after = laterSiblings.peek();
        }
        return after;
    }

    @CheckForNull
    private BlockStartNode getFirstEnclosingNode(FlowNode node) {
        List enclosingBlocks = node.getEnclosingBlocks();
        return enclosingBlocks.isEmpty() ? null : (BlockStartNode)enclosingBlocks.get(0);
    }

    private ArrayDeque<FlowNode> getProcessedChildren(@CheckForNull FlowNode node) {
        if (node != null && this.seenChildNodes.containsKey(node.getId())) {
            return this.seenChildNodes.get(node.getId());
        }
        return new ArrayDeque<FlowNode>();
    }

    private void addStepRelationship(@NonNull StepAtomNode step) {
        if (this.isDebugEnabled) {
            logger.debug("Generating relationship for step {}", (Object)step.getId());
        }
        FlowNode after = this.getAfterNode((FlowNode)step);
        if (this.isDebugEnabled) {
            logger.debug("Adding step for {}({}),{}({})", new Object[]{step.getId(), step.getClass().getName(), after == null ? "null" : after.getId(), after == null ? "null" : after.getClass().getName()});
        }
        NodeRelationship nodeRelationship = new NodeRelationship((FlowNode)step, (FlowNode)step, after);
        this.relationships.put(step.getId(), nodeRelationship);
    }

    private void handleBlockEnd(@NonNull BlockEndNode<?> endNode) {
        BlockStartNode startNode = endNode.getStartNode();
        this.endNodes.put(startNode.getId(), (FlowNode)endNode);
        ArrayDeque nodeBlockStack = new ArrayDeque();
        this.lastSeenNodes.push(nodeBlockStack);
    }

    private void addBlockRelationship(@NonNull FlowNode node) {
        NodeRelationship blockRelationship = null;
        FlowNode endNode = this.endNodes.getOrDefault(node.getId(), node);
        if (PipelineNodeUtil.isParallelBranch(node)) {
            this.addParallelBranchRelationship(node, endNode);
        } else {
            if (this.isDebugEnabled) {
                logger.debug("Adding relationship for {}", (Object)node.getId());
            }
            blockRelationship = !this.pendingBranchRelationships.isEmpty() ? this.addParallelRelationship(node, endNode) : this.addStageRelationship(node, endNode);
            this.relationships.put(node.getId(), blockRelationship);
            if (endNode != node) {
                this.relationships.put(endNode.getId(), blockRelationship);
            }
        }
    }

    private void addParallelBranchRelationship(@NonNull FlowNode node, @NonNull FlowNode endNode) {
        FlowNode after = this.getAfterNode(node);
        if (this.isDebugEnabled) {
            logger.debug("Adding parallel branch relationship for {}({})->{}({})", new Object[]{node.getId(), node.getClass().getName(), endNode.getId(), endNode.getClass().getName()});
        }
        NodeRelationship blockRelationship = new NodeRelationship(node, endNode, after);
        this.pendingBranchRelationships.push(blockRelationship);
    }

    private NodeRelationship addParallelRelationship(@NonNull FlowNode node, @NonNull FlowNode endNode) {
        FlowNode after = this.getAfterNode(node);
        if (this.isDebugEnabled) {
            logger.debug("Generating relationship for parallel Block {} (with after {})", (Object)node.getId(), (Object)(after != null ? after.getId() : "null"));
        }
        ParallelBlockRelationship parallelRelationship = new ParallelBlockRelationship(node, endNode, after, this.pendingBranchRelationships);
        for (NodeRelationship r : this.pendingBranchRelationships) {
            this.relationships.put(r.getStart().getId(), parallelRelationship);
            if (r.getEnd() == null) continue;
            this.relationships.put(r.getEnd().getId(), parallelRelationship);
        }
        this.pendingBranchRelationships.clear();
        return parallelRelationship;
    }

    private NodeRelationship addStageRelationship(@NonNull FlowNode node, @NonNull FlowNode endNode) {
        FlowNode after = this.getAfterNode(node);
        if (this.isDebugEnabled) {
            logger.debug("Generating relationship for Block {}{{}}->{}{{}} (with after {}{{}})", new Object[]{node.getId(), node.getClass(), endNode.getId(), endNode.getClass(), after != null ? after.getId() : "null", after != null ? after.getClass() : "null"});
        }
        return new NodeRelationship(node, endNode, after);
    }
}

