/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.Messages;
import io.jenkins.plugins.pipelinegraphview.analysis.TimingInfo;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStage;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepBuilderApi;
import java.util.Collections;
import java.util.List;

class PipelineStageInternal {
    private String name;
    private List<String> parents;
    private PipelineState state;
    private FlowNodeWrapper.NodeType type;
    private String title;
    private String id;
    private String seqContainerName;
    private PipelineStageInternal nextSibling;
    private boolean sequential;
    private boolean synthetic;
    private TimingInfo timingInfo;
    private String agent;
    private PipelineStepBuilderApi builder;

    public PipelineStageInternal(String id, String name, List<String> parents, PipelineState state, FlowNodeWrapper.NodeType type, String title, boolean synthetic, TimingInfo times, String agent) {
        this.id = id;
        this.name = name;
        this.parents = parents;
        this.state = state;
        this.type = type;
        this.title = title;
        this.synthetic = synthetic;
        this.timingInfo = times;
        this.agent = agent;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    public void setState(PipelineState state) {
        this.state = state;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNextSibling(PipelineStageInternal nextSibling) {
        this.nextSibling = nextSibling;
    }

    public void setSeqContainerName(String seqContainerName) {
        this.seqContainerName = seqContainerName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSeqContainerName() {
        return this.seqContainerName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public PipelineState getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String aAgent) {
        this.agent = aAgent;
    }

    public void setBuilder(PipelineStepBuilderApi builder) {
        this.builder = builder;
    }

    private boolean isWaitingForInput(List<PipelineStage> children) {
        List<FlowNodeWrapper> steps;
        if (children != null && !children.isEmpty()) {
            for (PipelineStage child : children) {
                if (child.state != PipelineState.PAUSED) continue;
                return true;
            }
        }
        if (this.builder != null && this.id != null && (steps = this.builder.getStageSteps(this.id)) != null) {
            for (FlowNodeWrapper step : steps) {
                if (step.getInputStep() == null || step.getStatus().state != BlueRun.BlueRunState.PAUSED) continue;
                return true;
            }
        }
        return false;
    }

    public PipelineStage toPipelineStage(List<PipelineStage> children, String runUrl) {
        boolean waitingForInput = this.isWaitingForInput(children);
        PipelineState effectiveState = waitingForInput ? PipelineState.PAUSED : this.state;
        return new PipelineStage(this.id, this.name, children, effectiveState, this.type.name(), this.title, this.seqContainerName, this.nextSibling != null ? this.nextSibling.toPipelineStage(Collections.emptyList(), runUrl) : null, this.sequential, this.synthetic, this.synthetic && this.name.equals(Messages.FlowNodeWrapper_noStage()), this.timingInfo, this.agent, runUrl);
    }
}

