/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.multipipelinegraphview;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.utils.ChangesUtil;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineRun {
    @NonNull
    private final String id;
    @NonNull
    private final String displayName;
    private final long timestamp;
    private final long duration;
    private final int changesCount;
    private final boolean building;
    @NonNull
    final PipelineState result;

    public PipelineRun(WorkflowRun run) {
        this(run.getId(), run.getDisplayName(), run.getTimeInMillis(), run.getDuration(), ChangesUtil.getChanges(run).size(), PipelineState.of(run), run.isBuilding());
    }

    PipelineRun(@NonNull String id, @NonNull String displayName, long timestamp, long duration, int changesCount, @NonNull PipelineState result, boolean building) {
        this.id = id;
        this.displayName = displayName;
        this.timestamp = timestamp;
        this.duration = duration;
        this.changesCount = changesCount;
        this.result = result;
        this.building = building;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public String etag() {
        return this.id + "|" + this.displayName + "|" + this.timestamp + "|" + this.duration + "|" + this.changesCount + "|" + this.result.name();
    }

    public static class PipelineRunJsonProcessor
    implements JsonBeanProcessor {
        public static void configure(JsonConfig config) {
            config.registerJsonBeanProcessor(PipelineRun.class, (JsonBeanProcessor)new PipelineRunJsonProcessor());
            PipelineState.PipelineStateJsonProcessor.configure(config);
        }

        public JSONObject processBean(Object bean, JsonConfig jsonConfig) {
            if (!(bean instanceof PipelineRun)) {
                return null;
            }
            PipelineRun run = (PipelineRun)bean;
            JSONObject json = new JSONObject();
            json.element("id", (Object)run.id);
            json.element("displayName", (Object)run.displayName);
            json.element("timestamp", run.timestamp);
            json.element("duration", run.duration);
            json.element("changesCount", run.changesCount);
            json.element("result", (Object)run.result, jsonConfig);
            return json;
        }
    }
}

