/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.multipipelinegraphview;

import hudson.model.Action;
import hudson.model.Item;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import hudson.util.RunList;
import io.jenkins.plugins.pipelinegraphview.PipelineGraphViewConfiguration;
import io.jenkins.plugins.pipelinegraphview.multipipelinegraphview.EtagBuilder;
import io.jenkins.plugins.pipelinegraphview.multipipelinegraphview.PipelineRun;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;

public class MultiPipelineGraphViewAction
implements Action,
IconSpec {
    private static final int MaxNumberOfElements = 10;
    private final WorkflowJob target;
    private static final JsonConfig jsonConfig = new JsonConfig();

    public MultiPipelineGraphViewAction(WorkflowJob target) {
        this.target = target;
    }

    public String getJobDisplayName() {
        return this.target.getDisplayName();
    }

    public boolean isBuildable() {
        return this.target.isBuildable();
    }

    public Permission getPermission() {
        return Item.BUILD;
    }

    public Permission getConfigurePermission() {
        return Item.CONFIGURE;
    }

    public boolean isShowGraphOnJobPage() {
        return PipelineGraphViewConfiguration.get().isShowGraphOnJobPage();
    }

    public boolean isShowStageNames() {
        return PipelineGraphViewConfiguration.get().isShowStageNames();
    }

    public boolean isShowStageDurations() {
        return PipelineGraphViewConfiguration.get().isShowStageDurations();
    }

    @GET
    @WebMethod(name={"runs"})
    public void getRuns(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        this.target.checkPermission(Item.READ);
        RunList runs = this.target.getBuilds();
        ArrayList<PipelineRun> pipelineRuns = new ArrayList<PipelineRun>();
        EtagBuilder etagBuilder = new EtagBuilder();
        for (WorkflowRun run : runs) {
            PipelineRun r = new PipelineRun(run);
            etagBuilder.add(r);
            pipelineRuns.add(r);
            if (pipelineRuns.size() < 10) continue;
            break;
        }
        String etag = etagBuilder.getEtag();
        String header = req.getHeader("If-None-Match");
        if (etag != null && etag.equals(header)) {
            rsp.setStatus(304);
            return;
        }
        HttpResponse response = HttpResponses.okJSON((JSONArray)JSONArray.fromObject(pipelineRuns, (JsonConfig)jsonConfig));
        if (etag != null) {
            rsp.setHeader("ETag", etag);
        }
        rsp.setHeader("Cache-Control", "no-cache");
        rsp.setStatus(200);
        response.generateResponse(req, rsp, null);
    }

    public String getJobUrl() {
        return this.target.getUrl();
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Stages";
    }

    public String getUrlName() {
        return "multi-pipeline-graph";
    }

    public String getIconClassName() {
        return "symbol-layers-outline plugin-ionicons-api";
    }

    static {
        PipelineRun.PipelineRunJsonProcessor.configure(jsonConfig);
    }
}

