/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflowhttp.cps;

import hudson.EnvVars;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class CachingConfiguration {
    private final int cachingMinutes;
    private final List<String[]> excludedCases;

    @DataBoundConstructor
    public CachingConfiguration(int cachingMinutes, String excludedCasesString) {
        this.cachingMinutes = cachingMinutes;
        this.excludedCases = new ArrayList<String[]>();
        for (String excludedCase : excludedCasesString.split(" ")) {
            String[] values = excludedCase.split("=");
            if (values.length != 2) continue;
            this.excludedCases.add(new String[]{values[0], values[1]});
        }
    }

    private static String createRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    public int getCachingMinutes() {
        return this.cachingMinutes;
    }

    public int getCachingSeconds() {
        return this.cachingMinutes * 60;
    }

    public String getExcludedCasesString() {
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        for (String[] pair : this.excludedCases) {
            results.add((CallSite)((Object)(pair[0] + "=" + pair[1])));
        }
        return String.join((CharSequence)" ", results);
    }

    public boolean isExcluded(EnvVars envVars) {
        for (String[] pair : this.excludedCases) {
            String key = pair[0];
            String value = pair[1];
            String pattern = CachingConfiguration.createRegexFromGlob(value);
            String envVar = (String)envVars.get((Object)key);
            if (envVar == null || !envVar.matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

