/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflowhttp.cps;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.flow.DurabilityHintProvider;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowDurabilityHint;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GlobalDefaultFlowDurabilityLevel;
import org.jenkinsci.plugins.workflowhttp.cps.CacheEntry;
import org.jenkinsci.plugins.workflowhttp.cps.CachingConfiguration;
import org.jenkinsci.plugins.workflowhttp.cps.RobustHTTPClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class CpsHttpFlowDefinition
extends FlowDefinition {
    private final String scriptUrl;
    private String setAcceptHeader;
    private String setKeyHeader;
    private String setValueHeader;
    private int retryCount;
    private CachingConfiguration cachingConfiguration;
    private String credentialsId;

    @Deprecated
    public CpsHttpFlowDefinition(String scriptUrl, String setAcceptHeader, String setKeyHeader, String setValueHeader, int retryCount, CachingConfiguration cachingConfiguration) {
        this.scriptUrl = scriptUrl.trim();
        this.setAcceptHeader = setAcceptHeader;
        this.setKeyHeader = setKeyHeader;
        this.setValueHeader = setValueHeader;
        this.retryCount = retryCount;
        this.cachingConfiguration = cachingConfiguration;
    }

    @DataBoundConstructor
    public CpsHttpFlowDefinition(String scriptUrl) {
        this.scriptUrl = scriptUrl.trim();
    }

    public String getScriptUrl() {
        return this.scriptUrl;
    }

    public String getSetAcceptHeader() {
        return this.setAcceptHeader;
    }

    public String getSetKeyHeader() {
        return this.setKeyHeader;
    }

    public String getSetValueHeader() {
        return this.setValueHeader;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public CachingConfiguration getCachingConfiguration() {
        return this.cachingConfiguration;
    }

    public Instant getExpirationDate() {
        return Instant.now().plusSeconds(this.cachingConfiguration.getCachingSeconds());
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setSetAcceptHeader(String setAcceptHeader) {
        this.setAcceptHeader = setAcceptHeader;
    }

    @DataBoundSetter
    public void setSetKeyHeader(String setKeyHeader) {
        this.setKeyHeader = setKeyHeader;
    }

    @DataBoundSetter
    public void setSetValueHeader(String setValueHeader) {
        this.setValueHeader = setValueHeader;
    }

    @DataBoundSetter
    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    @DataBoundSetter
    public void setCachingConfiguration(CachingConfiguration cachingConfiguration) {
        this.cachingConfiguration = cachingConfiguration;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public CpsFlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        UsernamePasswordCredentials credentials;
        for (Action action : actions) {
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create((FlowDefinition)this, owner, actions);
        }
        Queue.Executable _build = owner.getExecutable();
        if (!(_build instanceof Run)) {
            throw new IOException("Can only pull a Jenkinsfile in a run");
        }
        Run run = (Run)_build;
        EnvVars envVars = run.getEnvironment(listener);
        String expandedScriptUrl = envVars.expand(this.scriptUrl);
        listener.getLogger().println("Fetching pipeline from " + expandedScriptUrl);
        RobustHTTPClient client = new RobustHTTPClient();
        client.setStopAfterAttemptNumber(this.retryCount + 1);
        client.setWaitMultiplier(1L, TimeUnit.SECONDS);
        HttpGet httpGet = new HttpGet(expandedScriptUrl);
        if (this.setAcceptHeader != null && !this.setAcceptHeader.isEmpty()) {
            httpGet.setHeader("Accept", (Object)this.setAcceptHeader);
        }
        if (this.setKeyHeader != null && !this.setKeyHeader.isEmpty() && this.setValueHeader != null && !this.setValueHeader.isEmpty()) {
            httpGet.setHeader(this.setKeyHeader, (Object)this.setValueHeader);
        }
        if (this.credentialsId != null && (credentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId))) != null) {
            String encoded = Base64.getEncoder().encodeToString((credentials.getUsername() + ":" + String.valueOf(credentials.getPassword())).getBytes(StandardCharsets.UTF_8));
            httpGet.setHeader("Authorization", (Object)("Basic " + encoded));
            CredentialsProvider.track((Run)run, (Credentials)credentials);
        }
        AtomicReference<Object> scriptReference = new AtomicReference<Object>(null);
        boolean shouldCache = true;
        if (this.cachingConfiguration == null) {
            listener.getLogger().println("No caching config. Fetching from HTTP");
            shouldCache = false;
        }
        if (shouldCache && this.cachingConfiguration.isExcluded(envVars)) {
            listener.getLogger().println("Caching excluded from environment variables");
            shouldCache = false;
        }
        if (shouldCache) {
            ConcurrentHashMap<String, CacheEntry> pipelineCache = CacheEntry.cache;
            if (pipelineCache.containsKey(expandedScriptUrl)) {
                listener.getLogger().println("Fetching from cache");
                if (((CacheEntry)pipelineCache.get((Object)expandedScriptUrl)).expirationDate.isBefore(Instant.now())) {
                    listener.getLogger().println("Cache is expired. Clearing");
                    pipelineCache.remove(expandedScriptUrl);
                }
            } else {
                listener.getLogger().println("Cache miss. Actually fetching from HTTP");
            }
            if (!pipelineCache.containsKey(expandedScriptUrl)) {
                client.connect("get pipeline", "get pipeline from " + expandedScriptUrl, c -> c.execute((ClassicHttpRequest)httpGet), response -> {
                    try (InputStream is = response.getEntity().getContent();){
                        String script = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                        pipelineCache.put(expandedScriptUrl, new CacheEntry(this.getExpirationDate(), script));
                    }
                }, listener);
            }
            scriptReference.set(((CacheEntry)pipelineCache.get((Object)expandedScriptUrl)).script);
        } else {
            client.connect("get pipeline", "get pipeline from " + expandedScriptUrl, c -> c.execute((ClassicHttpRequest)httpGet), response -> {
                try (InputStream is = response.getEntity().getContent();){
                    String script = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    scriptReference.set(script);
                }
            }, listener);
        }
        Queue.Executable queueExec = owner.getExecutable();
        FlowDurabilityHint hint = queueExec instanceof Run ? DurabilityHintProvider.suggestedFor((Item)((Run)queueExec).getParent()) : GlobalDefaultFlowDurabilityLevel.getDefaultDurabilityHint();
        return new CpsFlowExecution((String)scriptReference.get(), true, owner, hint);
    }

    @Extension
    @Symbol(value={"cpsHttp"})
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Pipeline script from HTTP";
        }

        public Collection<? extends SCMDescriptor<?>> getApplicableDescriptors() {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            Job job = req != null ? (Job)req.findAncestorObject(Job.class) : null;
            return SCM._for((Job)job);
        }

        public FormValidation doCheckExcludedCasesString(@QueryParameter String value) {
            for (String splitValue : value.split(" ")) {
                if ((splitValue = splitValue.trim()).isEmpty() || splitValue.split("=").length == 2) continue;
                return FormValidation.error((String)"Each entry must contain one equal sign");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String scriptUrl, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)scriptUrl).build(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }
    }
}

