/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import java.util.function.Function;
import java.util.logging.Logger;

final class TimestampTracker {
    private static final Logger LOGGER = Logger.getLogger(TimestampTracker.class.getName());
    private long lastRecordedTimestamp;

    TimestampTracker() {
        LOGGER.fine("created new timestamp tracker");
    }

    synchronized long eventSent() {
        this.lastRecordedTimestamp = TimestampTracker.monoticallyIncrease(this.lastRecordedTimestamp, System.currentTimeMillis());
        return this.lastRecordedTimestamp;
    }

    static long monoticallyIncrease(long lastRecordedTimestamp, long now) {
        if (now > lastRecordedTimestamp) {
            return now;
        }
        if (lastRecordedTimestamp > now + 1000L) {
            return lastRecordedTimestamp;
        }
        return lastRecordedTimestamp + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkCompletion(Function<Long, Boolean> check) {
        long timestamp;
        TimestampTracker timestampTracker = this;
        synchronized (timestampTracker) {
            timestamp = this.lastRecordedTimestamp;
        }
        if (timestamp == 0L) {
            return true;
        }
        if (check.apply(timestamp).booleanValue()) {
            timestampTracker = this;
            synchronized (timestampTracker) {
                if (this.lastRecordedTimestamp == timestamp) {
                    this.lastRecordedTimestamp = 0L;
                }
            }
            return true;
        }
        return false;
    }
}

