/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.console.AnnotatedLargeText;
import hudson.model.BuildListener;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.pipeline_cloudwatch_logs.CloudWatchRetriever;
import io.jenkins.plugins.pipeline_cloudwatch_logs.CloudWatchSender;
import io.jenkins.plugins.pipeline_cloudwatch_logs.TimestampTracker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.BrokenLogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.jenkinsci.plugins.workflow.log.LogStorageFactory;

@Extension
public final class PipelineBridge
implements LogStorageFactory {
    private static final Logger LOGGER;
    private final Map<String, TimestampTracker> timestampTrackers = new ConcurrentHashMap<String, TimestampTracker>();
    private final Map<String, LogStorageImpl> impls = new ConcurrentHashMap<String, LogStorageImpl>();

    public LogStorage forBuild(FlowExecutionOwner owner) {
        String buildId;
        String logStreamNameBase;
        try {
            Queue.Executable exec = owner.getExecutable();
            if (!(exec instanceof Run)) {
                return null;
            }
            Run b = (Run)exec;
            logStreamNameBase = b.getParent().getFullName();
            buildId = b.getId();
        }
        catch (IOException x) {
            return new BrokenLogStorage((Throwable)x);
        }
        return this.forIDs(logStreamNameBase, buildId);
    }

    static PipelineBridge get() {
        return (PipelineBridge)ExtensionList.lookupSingleton(PipelineBridge.class);
    }

    LogStorage forIDs(String logStreamNameBase, String buildId) {
        return this.impls.computeIfAbsent(logStreamNameBase + "#" + buildId, k -> new LogStorageImpl(logStreamNameBase, buildId, this.timestampTrackers));
    }

    void close(String logStreamNameBase, String buildId) {
        this.impls.remove(logStreamNameBase + "#" + buildId);
    }

    static {
        System.setProperty("org.jenkinsci.plugins.workflow.steps.durable_task.DurableTaskStep.USE_WATCHING", "true");
        LOGGER = Logger.getLogger(PipelineBridge.class.getName());
    }

    private static class LogStorageImpl
    implements LogStorage {
        private final String logStreamNameBase;
        private final String buildId;
        private final Map<String, TimestampTracker> timestampTrackers;

        LogStorageImpl(String logStreamName, String buildId, Map<String, TimestampTracker> timestampTrackers) {
            this.logStreamNameBase = logStreamName;
            this.buildId = buildId;
            this.timestampTrackers = timestampTrackers;
        }

        public BuildListener overallListener() throws IOException, InterruptedException {
            return new CloudWatchSender.MasterSender(this.logStreamNameBase, this.buildId, null, this.timestampTracker());
        }

        public TaskListener nodeListener(FlowNode node) throws IOException, InterruptedException {
            return new CloudWatchSender.MasterSender(this.logStreamNameBase, this.buildId, node.getId(), this.timestampTracker());
        }

        public AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(FlowExecutionOwner.Executable build, boolean complete) {
            try {
                return new CloudWatchRetriever(this.logStreamNameBase, this.buildId, this.timestampTracker()).overallLog(build, complete);
            }
            catch (Exception x) {
                return new BrokenLogStorage((Throwable)x).overallLog(build, complete);
            }
        }

        public AnnotatedLargeText<FlowNode> stepLog(FlowNode node, boolean complete) {
            try {
                return new CloudWatchRetriever(this.logStreamNameBase, this.buildId, this.timestampTracker()).stepLog(node, complete);
            }
            catch (Exception x) {
                return new BrokenLogStorage((Throwable)x).stepLog(node, complete);
            }
        }

        @Deprecated
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="forBuild only accepts Run")
        public File getLogFile(FlowExecutionOwner.Executable build, boolean complete) {
            AnnotatedLargeText<FlowExecutionOwner.Executable> logText = this.overallLog(build, complete);
            File f = new File(((Run)build).getRootDir(), "log");
            f.deleteOnExit();
            try (FileOutputStream os = new FileOutputStream(f);){
                long pos2;
                long pos = 0L;
                while ((pos2 = logText.writeRawLogTo(pos, (OutputStream)os)) > pos) {
                    pos = pos2;
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            return f;
        }

        private TimestampTracker timestampTracker() {
            return this.timestampTrackers.computeIfAbsent(this.logStreamNameBase + "#" + this.buildId, k -> new TimestampTracker());
        }
    }
}

