/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import io.jenkins.plugins.aws.global_configuration.CredentialsAwsGlobalConfiguration;
import io.jenkins.plugins.pipeline_cloudwatch_logs.CloudWatchAwsGlobalConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.HMACConfidentialKey;
import jenkins.security.SlaveToMasterCallable;
import jenkins.util.JenkinsJVM;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidSequenceTokenException;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.RejectedLogEventsInfo;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.Credentials;

abstract class LogStreamState {
    private static final Logger LOGGER = Logger.getLogger(LogStreamState.class.getName());
    private static final Map<String, LogStreamState> states = new ConcurrentHashMap<String, LogStreamState>();
    private static final HMACConfidentialKey TOKENS = new HMACConfidentialKey(MasterState.class, "TOKENS");
    protected final String logGroupName;
    protected final String logStreamNameBase;
    @NonNull
    private final BlockingQueue<InputLogEvent> events = new ArrayBlockingQueue<InputLogEvent>(10000);
    private long lastOffered;

    private static String key(String logGroupName, String logStreamNameBase) {
        return logGroupName + "#" + logStreamNameBase;
    }

    static LogStreamState onMaster(String logGroupName, String logStreamNameBase) {
        return states.computeIfAbsent(LogStreamState.key(logGroupName, logStreamNameBase), k -> new MasterState(logGroupName, logStreamNameBase));
    }

    static LogStreamState onAgent(String logGroupName, String logStreamNameBase, String token, Channel channel) {
        String key = LogStreamState.key(logGroupName, logStreamNameBase);
        return states.computeIfAbsent(key, k -> new AgentState(logGroupName, logStreamNameBase, token, channel));
    }

    private LogStreamState(String logGroupName, String logStreamNameBase) {
        this.logGroupName = logGroupName;
        this.logStreamNameBase = logStreamNameBase;
    }

    @CheckForNull
    static String validate(@NonNull String logGroupName) throws IOException {
        Auth auth = ((MasterState)LogStreamState.onMaster(logGroupName, "__example__")).authenticate();
        if (auth.restricted) {
            return null;
        }
        if (auth.accessKeyId != null) {
            return "Giving up on limiting session credentials to a policy; using " + auth.accessKeyId + " as is: " + String.valueOf(StsClient.create().getCallerIdentity());
        }
        return "No AWS credentials to be found, giving up on limiting to a policy";
    }

    @NonNull
    protected abstract String token();

    @NonNull
    protected abstract CloudWatchLogsClient client() throws IOException, InterruptedException;

    @NonNull
    protected abstract String logStreamName() throws IOException, InterruptedException;

    protected abstract void ensureRunning() throws IOException;

    protected abstract void shutDown();

    boolean offer(InputLogEvent event) throws IOException, InterruptedException {
        this.ensureRunning();
        this.lastOffered = Math.max(this.lastOffered, event.timestamp());
        return this.events.offer(event, 1L, TimeUnit.MINUTES);
    }

    protected void schedule() {
        new Thread(this::process, "CloudWatch Logs delivery: " + this.logGroupName + "/" + this.logStreamNameBase).start();
    }

    private void process() {
        CloudWatchLogsClient currentClient;
        String logStreamName;
        try {
            logStreamName = this.logStreamName();
            currentClient = this.client();
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
            this.shutDown();
            return;
        }
        String sequenceToken = null;
        block11: while (true) {
            ArrayList<InputLogEvent> processing;
            if (this.events.drainTo(processing = new ArrayList<InputLogEvent>()) == 0) {
                LOGGER.log(Level.FINEST, "waiting for events from {0}", new Object[]{logStreamName});
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                continue;
            }
            assert (!processing.isEmpty());
            processing.sort(Comparator.comparing(InputLogEvent::timestamp));
            while (true) {
                try {
                    String _sequenceToken = sequenceToken;
                    PutLogEventsResponse result = currentClient.putLogEvents(b -> b.logGroupName(this.logGroupName).logStreamName(logStreamName).sequenceToken(_sequenceToken).logEvents((Collection)processing));
                    sequenceToken = result.nextSequenceToken();
                    RejectedLogEventsInfo problems = result.rejectedLogEventsInfo();
                    if (problems == null) break;
                    LOGGER.log(Level.WARNING, "Rejected some log events: {0}", problems);
                }
                catch (InvalidSequenceTokenException x) {
                    LOGGER.fine("Recovering from InvalidSequenceTokenException");
                    sequenceToken = x.expectedSequenceToken();
                    continue;
                }
                catch (InvalidParameterException x) {
                    LOGGER.log(Level.WARNING, null, x);
                    break block11;
                }
                catch (SdkException x) {
                    LOGGER.log(Level.FINE, "retrying", x);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException x2) {
                        LOGGER.log(Level.WARNING, null, x2);
                    }
                    continue;
                }
                catch (RuntimeException x) {
                    LOGGER.log(Level.WARNING, "giving up on this stream", x);
                    break block11;
                }
                break;
            }
            LOGGER.log(Level.FINER, "sent {0} events @{1} from {2}", new Object[]{processing.size(), ((InputLogEvent)processing.get(processing.size() - 1)).timestamp(), logStreamName});
        }
        this.shutDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void flush() throws IOException {
        LOGGER.log(Level.FINE, "flushing {0}", this.logStreamNameBase);
        long start = System.nanoTime();
        while (true) {
            if (System.nanoTime() - start >= TimeUnit.MINUTES.toNanos(1L)) {
                throw new IOException("there are still unflushed log events");
            }
            try {
                if (this.events.isEmpty()) {
                    if (this.lastOffered <= 0L) {
                        LOGGER.log(Level.FINER, "no events delivered in {0}", this.logStreamNameBase);
                        return;
                    }
                    LOGGER.log(Level.FINER, "all events up to {0} delivered in {1}; confirming receipt", new Object[]{this.lastOffered, this.logStreamNameBase});
                    String logStreamName = this.logStreamName();
                    if (!this.client().getLogEvents(b -> b.logGroupName(this.logGroupName).logStreamName(logStreamName).limit(Integer.valueOf(1)).startTime(Long.valueOf(this.lastOffered))).events().isEmpty()) {
                        LOGGER.log(Level.FINER, "confirmed event delivery in {0} with timestamp={1}", new Object[]{logStreamName, this.lastOffered});
                        return;
                    }
                    LOGGER.log(Level.FINER, "delivered an event in {0} with timestamp={1} but it has not yet been received", new Object[]{logStreamName, this.lastOffered});
                }
                Thread.sleep(100L);
            }
            catch (IOException x) {
                LOGGER.log(Level.FINER, null, x);
                throw x;
            }
            catch (Exception x) {
                LOGGER.log(Level.FINER, null, x);
                throw new IOException(x);
            }
        }
    }

    private static final class MasterState
    extends LogStreamState {
        @CheckForNull
        private CloudWatchLogsClient client;
        private final Set<String> agentLogStreamNames = new HashSet<String>();

        private MasterState(String logGroupName, String logStreamNameBase) {
            super(logGroupName, logStreamNameBase);
            JenkinsJVM.checkJenkinsJVM();
        }

        @Override
        protected String token() {
            return TOKENS.mac(LogStreamState.key(this.logGroupName, this.logStreamNameBase));
        }

        @Override
        protected synchronized CloudWatchLogsClient client() throws IOException {
            if (this.client == null) {
                this.client = ((CloudWatchAwsGlobalConfiguration)((Object)ExtensionList.lookupSingleton(CloudWatchAwsGlobalConfiguration.class))).getCloudWatchLogsClient();
            }
            return this.client;
        }

        @Override
        protected String logStreamName() {
            return this.logStreamNameBase + "@master";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void ensureRunning() throws IOException {
            boolean starting;
            MasterState masterState = this;
            synchronized (masterState) {
                starting = this.client == null;
            }
            if (starting) {
                this.create(this.logStreamName());
                this.schedule();
            }
        }

        @Override
        protected synchronized void shutDown() {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }

        private void create(String logStreamName) throws IOException {
            CloudWatchLogsClient currentClient = this.client();
            boolean found = false;
            String token = null;
            do {
                String _token = token;
                DescribeLogStreamsResponse r = currentClient.describeLogStreams(b -> b.logGroupName(this.logGroupName).logStreamNamePrefix(logStreamName).nextToken(_token));
                for (LogStream ls : r.logStreams()) {
                    if (!ls.logStreamName().equals(logStreamName)) continue;
                    found = true;
                }
                token = r.nextToken();
            } while (!found && token != null);
            if (!found) {
                LOGGER.log(Level.FINE, "Creating {0}", logStreamName);
                currentClient.createLogStream(b -> b.logGroupName(this.logGroupName).logStreamName(logStreamName));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Auth authenticate() throws IOException {
            String agentLogStreamName;
            CredentialsAwsGlobalConfiguration credentialsConfig = CredentialsAwsGlobalConfiguration.get();
            String region = credentialsConfig.getRegion();
            AmazonWebServicesCredentials jenkinsCredentials = credentialsConfig.getCredentials();
            AwsCredentials masterCredentials = jenkinsCredentials != null ? jenkinsCredentials.resolveCredentials() : DefaultCredentialsProvider.create().resolveCredentials();
            Set<String> set = this.agentLogStreamNames;
            synchronized (set) {
                String candidate;
                int i = 1;
                while (true) {
                    if (this.agentLogStreamNames.add(candidate = this.logStreamNameBase + "@agent" + i)) break;
                    ++i;
                }
                agentLogStreamName = candidate;
            }
            if (masterCredentials instanceof AwsSessionCredentials) {
                AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)masterCredentials;
                String role = System.getenv("AWS_CHAINED_ROLE");
                if (jenkinsCredentials instanceof AWSCredentialsImpl) {
                    role = Util.fixEmpty((String)((AWSCredentialsImpl)jenkinsCredentials).getIamRoleArn());
                }
                if (role != null) {
                    return this.assumeRole(role, region, agentLogStreamName);
                }
                return new Auth(sessionCredentials, region, agentLogStreamName);
            }
            if (masterCredentials == null) {
                return new Auth(region, agentLogStreamName);
            }
            StsClientBuilder builder = StsClient.builder();
            if (region != null) {
                builder = (StsClientBuilder)builder.region(Region.of((String)region));
            }
            if (jenkinsCredentials != null) {
                builder.credentialsProvider((AwsCredentialsProvider)jenkinsCredentials);
            }
            return this.getFederationToken(builder, region, agentLogStreamName);
        }

        private Auth assumeRole(String role, String region, String agentLogStreamName) {
            StsClientBuilder builder = StsClient.builder();
            if (region != null) {
                builder = (StsClientBuilder)builder.region(Region.of((String)region));
            }
            Credentials credentials = ((StsClient)builder.build()).assumeRole(b -> b.roleArn(role).roleSessionName("CloudWatchSender-" + String.valueOf(UUID.randomUUID())).policy(this.policy(agentLogStreamName))).credentials();
            Auth auth = new Auth(credentials, region, agentLogStreamName);
            LOGGER.fine(() -> "AssumeRole succeeded; using " + String.valueOf(((StsClient)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)credentials.accessKeyId(), (String)credentials.secretAccessKey(), (String)credentials.sessionToken())))).build()).getCallerIdentity()));
            return auth;
        }

        private Auth getFederationToken(StsClientBuilder builder, String region, String agentLogStreamName) {
            Auth auth = new Auth(((StsClient)builder.build()).getFederationToken(b -> b.name("CloudWatchSender-" + String.valueOf(UUID.randomUUID())).policy(this.policy(agentLogStreamName))).credentials(), region, agentLogStreamName);
            LOGGER.log(Level.FINE, "GetFederationToken succeeded; using {0}", auth.accessKeyId);
            return auth;
        }

        private String policy(String agentLogStreamName) {
            return "{\"Version\": \"2012-10-17\", \"Statement\": [{\"Effect\": \"Allow\", \"Action\": [\"logs:PutLogEvents\", \"logs:GetLogEvents\"], \"Resource\": [\"arn:aws:logs:*:*:log-group:" + this.logGroupName + ":log-stream:" + agentLogStreamName + "\"]}]}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyShutdown(String agentLogStreamName) {
            Set<String> set = this.agentLogStreamNames;
            synchronized (set) {
                this.agentLogStreamNames.remove(agentLogStreamName);
            }
        }
    }

    private static final class Auth
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @CheckForNull
        final String accessKeyId;
        @Nullable
        final String secretAccessKey;
        @Nullable
        final String sessionToken;
        @CheckForNull
        final String region;
        @NonNull
        final String logStreamName;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="only used in validation")
        final transient boolean restricted;

        Auth(Credentials credentials, String region, String logStreamName) {
            this(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken(), region, logStreamName, true);
        }

        Auth(AwsSessionCredentials credentials, String region, String logStreamName) {
            this(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken(), region, logStreamName, false);
        }

        Auth(String region, String logStreamName) {
            this(null, null, null, region, logStreamName, false);
        }

        private Auth(String accessKeyId, String secretAccessKey, String sessionToken, String region, String logStreamName, boolean restricted) {
            this.accessKeyId = accessKeyId;
            this.secretAccessKey = secretAccessKey;
            this.sessionToken = sessionToken;
            this.region = region;
            this.logStreamName = logStreamName;
            this.restricted = restricted;
        }

        CloudWatchLogsClient client() {
            if (this.accessKeyId != null) {
                CloudWatchLogsClientBuilder builder = CloudWatchLogsClient.builder();
                if (this.region != null) {
                    builder = (CloudWatchLogsClientBuilder)builder.region(Region.of((String)this.region));
                }
                builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey, (String)this.sessionToken)));
                return (CloudWatchLogsClient)builder.build();
            }
            return CloudWatchAwsGlobalConfiguration.getCloudWatchLogsClient(this.region, null);
        }
    }

    private static final class AgentState
    extends LogStreamState {
        @NonNull
        private final String token;
        @CheckForNull
        private CloudWatchLogsClient client;
        @Nullable
        private String logStreamName;
        @NonNull
        private final Channel channel;

        AgentState(String logGroupName, String logStreamNameBase, String token, Channel channel) {
            super(logGroupName, logStreamNameBase);
            this.token = token;
            this.channel = channel;
            JenkinsJVM.checkNotJenkinsJVM();
        }

        @Override
        protected String token() {
            return this.token;
        }

        @Override
        protected synchronized CloudWatchLogsClient client() throws IOException, InterruptedException {
            if (this.client == null) {
                Auth auth = (Auth)this.channel.call((Callable)new Authenticate(this.logGroupName, this.logStreamNameBase, this.token));
                this.client = auth.client();
                this.logStreamName = auth.logStreamName;
            }
            return this.client;
        }

        @Override
        protected String logStreamName() throws IOException, InterruptedException {
            this.client();
            return this.logStreamName;
        }

        @Override
        protected synchronized void ensureRunning() {
            if (this.client == null) {
                this.schedule();
            }
        }

        @Override
        protected synchronized void shutDown() {
            if (this.client != null) {
                this.client.close();
                this.client = null;
                try {
                    this.channel.callAsync((Callable)new NotifyShutdown(this.logGroupName, this.logStreamNameBase, this.token, this.logStreamName));
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
                this.logStreamName = null;
            }
        }
    }

    private static final class NotifyShutdown
    extends SecuredCallable<Void, RuntimeException> {
        private static final long serialVersionUID = 1L;
        private final String agentLogStreamName;

        NotifyShutdown(String logGroupName, String logStreamNameBase, String token, String agentLogStreamName) {
            super(logGroupName, logStreamNameBase, token);
            this.agentLogStreamName = agentLogStreamName;
        }

        @Override
        protected Void doCall(MasterState state) {
            if (!this.agentLogStreamName.startsWith(this.logStreamNameBase + "@")) {
                throw new SecurityException();
            }
            state.notifyShutdown(this.agentLogStreamName);
            return null;
        }
    }

    private static final class Authenticate
    extends SecuredCallable<Auth, IOException> {
        private static final long serialVersionUID = 1L;

        Authenticate(String logGroupName, String logStreamNameBase, String token) {
            super(logGroupName, logStreamNameBase, token);
        }

        @Override
        protected Auth doCall(MasterState state) throws IOException {
            Auth auth = state.authenticate();
            state.create(auth.logStreamName);
            return auth;
        }
    }

    private static abstract class SecuredCallable<V, T extends Throwable>
    extends SlaveToMasterCallable<V, T> {
        private static final long serialVersionUID = 1L;
        protected final String logGroupName;
        protected final String logStreamNameBase;
        private final String token;

        protected SecuredCallable(String logGroupName, String logStreamNameBase, String token) {
            this.logGroupName = logGroupName;
            this.logStreamNameBase = logStreamNameBase;
            this.token = token;
        }

        public V call() throws T {
            MasterState state = (MasterState)LogStreamState.onMaster(this.logGroupName, this.logStreamNameBase);
            if (!TOKENS.checkMac(LogStreamState.key(this.logGroupName, this.logStreamNameBase), this.token)) {
                throw new SecurityException();
            }
            return this.doCall(state);
        }

        protected abstract V doCall(MasterState var1) throws T;
    }
}

