/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

class ConsoleNotes {
    private static final String MESSAGE_KEY = "message";
    private static final String ANNOTATIONS_KEY = "annotations";
    private static final String POSITION_KEY = "position";
    private static final String NOTE_KEY = "note";

    static Map<String, Object> parse(byte[] b, int len) {
        byte c;
        int eol;
        assert (len > 0 && len <= b.length);
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (eol = len; eol > 0 && ((c = b[eol - 1]) == 10 || c == 13); --eol) {
        }
        String line = new String(b, 0, eol, StandardCharsets.UTF_8);
        if (!line.contains("\u001b[8mha:")) {
            data.put(MESSAGE_KEY, line);
        } else {
            int endOfPreamble;
            int postamble;
            int preamble;
            StringBuilder buf = new StringBuilder();
            ArrayList<ImmutableMap> annotations = new ArrayList<ImmutableMap>();
            int pos = 0;
            while ((preamble = line.indexOf("\u001b[8mha:", pos)) != -1 && (postamble = line.indexOf("\u001b[0m", endOfPreamble = preamble + "\u001b[8mha:".length())) != -1) {
                buf.append(line, pos, preamble);
                annotations.add(ImmutableMap.of((Object)POSITION_KEY, (Object)buf.length(), (Object)NOTE_KEY, (Object)line.substring(endOfPreamble, postamble)));
                pos = postamble + "\u001b[0m".length();
            }
            buf.append(line, pos, line.length());
            data.put(MESSAGE_KEY, buf.toString());
            data.put(ANNOTATIONS_KEY, annotations);
        }
        return data;
    }

    static void write(Writer w, JSONObject json) throws IOException {
        String message = json.getString(MESSAGE_KEY);
        JSONArray annotations = json.optJSONArray(ANNOTATIONS_KEY);
        if (annotations == null) {
            w.write(message);
        } else {
            int pos = 0;
            for (Object o : annotations) {
                JSONObject annotation = (JSONObject)o;
                int position = annotation.getInt(POSITION_KEY);
                String note = annotation.getString(NOTE_KEY);
                w.write(message, pos, position - pos);
                w.write("\u001b[8mha:");
                w.write(note);
                w.write("\u001b[0m");
                pos = position;
            }
            w.write(message, pos, message.length() - pos);
        }
        w.write(10);
    }

    private ConsoleNotes() {
    }
}

