/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.ExtensionList;
import hudson.console.LineTransformationOutputStream;
import hudson.model.BuildListener;
import hudson.remoting.Channel;
import io.jenkins.plugins.pipeline_cloudwatch_logs.CloudWatchAwsGlobalConfiguration;
import io.jenkins.plugins.pipeline_cloudwatch_logs.ConsoleNotes;
import io.jenkins.plugins.pipeline_cloudwatch_logs.LogStreamState;
import io.jenkins.plugins.pipeline_cloudwatch_logs.PipelineBridge;
import io.jenkins.plugins.pipeline_cloudwatch_logs.TimestampTracker;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JenkinsJVM;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.log.OutputStreamTaskListener;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;

abstract class CloudWatchSender
extends OutputStreamTaskListener.Default
implements BuildListener,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(CloudWatchSender.class.getName());
    private static final long serialVersionUID = 1L;
    @NonNull
    protected final String logGroupName;
    @NonNull
    protected final String logStreamNameBase;
    @NonNull
    protected final String buildId;
    @CheckForNull
    protected final String nodeId;
    @CheckForNull
    private transient CloudWatchOutputStream logger;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Only need to synchronize initialization; thereafter it remains set.")
    @CheckForNull
    private transient TimestampTracker timestampTracker;
    @Nullable
    protected transient LogStreamState state;

    protected CloudWatchSender(@NonNull String logGroupName, @NonNull String logStreamNameBase, @NonNull String buildId, @CheckForNull String nodeId, @CheckForNull TimestampTracker timestampTracker) {
        this.logGroupName = Objects.requireNonNull(logGroupName);
        this.logStreamNameBase = Objects.requireNonNull(logStreamNameBase);
        this.buildId = Objects.requireNonNull(buildId);
        this.nodeId = nodeId;
        this.timestampTracker = timestampTracker;
    }

    protected abstract LogStreamState loadState();

    public final synchronized OutputStream getOutputStream() {
        if (this.logger == null) {
            if (this.timestampTracker == null) {
                this.timestampTracker = new TimestampTracker();
            }
            this.state = this.loadState();
            this.logger = new CloudWatchOutputStream();
        }
        return this.logger;
    }

    @Override
    public final synchronized void close() throws IOException {
        if (this.state != null) {
            this.state.flush();
        }
        if (this.logger != null) {
            LOGGER.log(Level.FINE, "closing {0}/{1}#{2}", new Object[]{this.logStreamNameBase, this.buildId, this.nodeId});
            this.logger = null;
        }
        if (this.nodeId != null && JenkinsJVM.isJenkinsJVM()) {
            PipelineBridge.get().close(this.logStreamNameBase, this.buildId);
        }
    }

    private class CloudWatchOutputStream
    extends LineTransformationOutputStream {
        private CloudWatchOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void eol(byte[] b, int len) throws IOException {
            CloudWatchSender cloudWatchSender = CloudWatchSender.this;
            synchronized (cloudWatchSender) {
                if (CloudWatchSender.this.logger == null) {
                    LOGGER.log(Level.FINER, "refusing to schedule event from closed or broken {0}/{1}#{2}", new Object[]{CloudWatchSender.this.logStreamNameBase, CloudWatchSender.this.buildId, CloudWatchSender.this.nodeId});
                    return;
                }
            }
            Map<String, Object> data = ConsoleNotes.parse(b, len);
            data.put("build", CloudWatchSender.this.buildId);
            if (CloudWatchSender.this.nodeId != null) {
                data.put("node", CloudWatchSender.this.nodeId);
            }
            assert (CloudWatchSender.this.timestampTracker != null) : "getLogger which creates CloudWatchOutputStream initializes it";
            long now = CloudWatchSender.this.timestampTracker.eventSent();
            try {
                if (CloudWatchSender.this.state.offer((InputLogEvent)InputLogEvent.builder().timestamp(Long.valueOf(now)).message(JSONObject.fromObject(data).toString()).build())) {
                    LOGGER.log(Level.FINER, "scheduled event @{0} from {1}/{2}#{3}", new Object[]{now, CloudWatchSender.this.logStreamNameBase, CloudWatchSender.this.buildId, CloudWatchSender.this.nodeId});
                } else {
                    LOGGER.warning("Message buffer full, giving up");
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to send a message", x);
            }
        }

        public void flush() throws IOException {
            CloudWatchSender.this.state.flush();
        }
    }

    static final class AgentSender
    extends CloudWatchSender {
        private static final long serialVersionUID = 1L;
        private final String token;
        private transient Channel channel;

        AgentSender(String logGroupName, String logStreamNameBase, String buildId, String nodeId, String token) {
            super(logGroupName, logStreamNameBase, buildId, nodeId, null);
            this.token = token;
        }

        private Object readResolve() {
            this.channel = Channel.currentOrFail();
            return this;
        }

        @Override
        protected LogStreamState loadState() {
            return LogStreamState.onAgent(this.logGroupName, this.logStreamNameBase, this.token, this.channel);
        }
    }

    static final class MasterSender
    extends CloudWatchSender {
        private static final long serialVersionUID = 1L;

        MasterSender(String logStreamNameBase, String buildId, String nodeId, TimestampTracker timestampTracker) throws IOException {
            super(MasterSender.logGroupName(), logStreamNameBase, buildId, nodeId, timestampTracker);
        }

        private static String logGroupName() throws IOException {
            String logGroupName = ((CloudWatchAwsGlobalConfiguration)((Object)ExtensionList.lookupSingleton(CloudWatchAwsGlobalConfiguration.class))).getLogGroupName();
            if (logGroupName == null) {
                throw new AbortException("You must specify the CloudWatch log group name");
            }
            return logGroupName;
        }

        @Override
        protected LogStreamState loadState() {
            return LogStreamState.onMaster(this.logGroupName, this.logStreamNameBase);
        }

        private Object writeReplace() throws IOException {
            if (this.state == null) {
                this.state = this.loadState();
            }
            return new AgentSender(this.logGroupName, this.logStreamNameBase, this.buildId, this.nodeId, this.state.token());
        }
    }
}

