/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Failure;
import hudson.util.FormValidation;
import io.jenkins.plugins.aws.global_configuration.AbstractAwsGlobalConfiguration;
import io.jenkins.plugins.aws.global_configuration.CredentialsAwsGlobalConfiguration;
import io.jenkins.plugins.pipeline_cloudwatch_logs.LogStreamState;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;

@Symbol(value={"cloudWatchLogs"})
@Extension
public class CloudWatchAwsGlobalConfiguration
extends AbstractAwsGlobalConfiguration {
    private String logGroupName;

    public CloudWatchAwsGlobalConfiguration() {
        this.load();
    }

    CloudWatchAwsGlobalConfiguration(boolean test) {
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    @DataBoundSetter
    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
        this.checkValue(this.doCheckLogGroupName(logGroupName));
        this.save();
    }

    private void checkValue(@NonNull FormValidation formValidation) {
        if (formValidation.kind == FormValidation.Kind.ERROR) {
            throw new Failure(formValidation.getMessage());
        }
    }

    @NonNull
    public String getDisplayName() {
        return "Amazon CloudWatch Logs settings";
    }

    public CloudWatchLogsClient getCloudWatchLogsClient() throws IOException {
        return CloudWatchAwsGlobalConfiguration.getCloudWatchLogsClient(CredentialsAwsGlobalConfiguration.get().getRegion(), CredentialsAwsGlobalConfiguration.get().getCredentialsId());
    }

    @Restricted(value={NoExternalUse.class})
    static CloudWatchLogsClient getCloudWatchLogsClient(String region, String credentialsId) {
        AmazonWebServicesCredentials c;
        CloudWatchLogsClientBuilder builder = CloudWatchLogsClient.builder();
        if (region != null) {
            builder = (CloudWatchLogsClientBuilder)builder.region(Region.of((String)region));
        }
        if (credentialsId != null && (c = CredentialsAwsGlobalConfiguration.get().getCredentials(credentialsId)) != null) {
            builder.credentialsProvider((AwsCredentialsProvider)c);
        }
        return (CloudWatchLogsClient)builder.build();
    }

    public FormValidation doCheckLogGroupName(@QueryParameter String logGroupName) {
        FormValidation ret = FormValidation.ok();
        if (StringUtils.isBlank((String)logGroupName)) {
            ret = FormValidation.warning((String)"The log group name cannot be empty");
        }
        return ret;
    }

    @RequirePOST
    public FormValidation doValidate(@QueryParameter String logGroupName, @QueryParameter String region, @QueryParameter String credentialsId) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this.validate(logGroupName, Util.fixEmptyAndTrim((String)region), Util.fixEmptyAndTrim((String)credentialsId), true);
    }

    @Restricted(value={NoExternalUse.class})
    FormValidation validate(String logGroupName, String region, String credentialsId, boolean abbreviate) {
        CloudWatchLogsClient client;
        try {
            client = CloudWatchAwsGlobalConfiguration.getCloudWatchLogsClient(region, credentialsId);
        }
        catch (Exception x) {
            String msg = this.processExceptionMessage(x);
            return FormValidation.error((String)("Unable to validate credentials: " + (abbreviate ? StringUtils.abbreviate((String)msg, (int)200) : msg)));
        }
        try {
            this.filter(client, logGroupName);
        }
        catch (Exception x) {
            String msg = this.processExceptionMessage(x);
            return FormValidation.error((String)StringUtils.abbreviate((String)msg, (int)200));
        }
        try {
            String message = LogStreamState.validate(logGroupName);
            if (message != null) {
                return FormValidation.warning((String)message);
            }
        }
        catch (Exception x) {
            String msg = this.processExceptionMessage(x);
            return FormValidation.error((String)("Unable to simulate policy restriction: " + (abbreviate ? StringUtils.abbreviate((String)msg, (int)200) : msg)));
        }
        return FormValidation.ok((String)"success");
    }

    @Restricted(value={NoExternalUse.class})
    protected void filter(CloudWatchLogsClient client, String logGroupName) {
        client.filterLogEvents(b -> b.logGroupName(logGroupName));
    }
}

