/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_cloudwatch_logs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.ExtensionList;
import hudson.Main;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleAnnotationOutputStream;
import hudson.console.ConsoleAnnotator;
import io.jenkins.plugins.pipeline_cloudwatch_logs.CloudWatchAwsGlobalConfiguration;
import io.jenkins.plugins.pipeline_cloudwatch_logs.ConsoleNotes;
import io.jenkins.plugins.pipeline_cloudwatch_logs.TimestampTracker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.ConsoleAnnotators;
import org.jenkinsci.plugins.workflow.log.LogStorage;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceNotFoundException;

class CloudWatchRetriever {
    private static final Logger LOGGER = Logger.getLogger(CloudWatchRetriever.class.getName());
    private final String logStreamNameBase;
    private final String buildId;
    private final TimestampTracker timestampTracker;
    private final String logGroupName;
    private final CloudWatchLogsClient client;

    CloudWatchRetriever(String logStreamNameBase, String buildId, TimestampTracker timestampTracker) throws IOException {
        this.logStreamNameBase = logStreamNameBase;
        this.buildId = buildId;
        this.timestampTracker = timestampTracker;
        CloudWatchAwsGlobalConfiguration configuration = (CloudWatchAwsGlobalConfiguration)((Object)ExtensionList.lookupSingleton(CloudWatchAwsGlobalConfiguration.class));
        this.logGroupName = configuration.getLogGroupName();
        if (this.logGroupName == null) {
            throw new AbortException("You must specify the CloudWatch log group name");
        }
        this.client = configuration.getCloudWatchLogsClient();
    }

    AnnotatedLargeText<FlowExecutionOwner.Executable> overallLog(FlowExecutionOwner.Executable build, boolean complete) throws IOException, InterruptedException {
        return new OverallLog(build, complete);
    }

    AnnotatedLargeText<FlowNode> stepLog(FlowNode node, boolean completed) throws IOException {
        ByteBuffer buf = new ByteBuffer();
        boolean markedCompleted = completed && this.couldBeComplete();
        this.stream((OutputStream)buf, node.getId(), null);
        return new AnnotatedLargeText(buf, StandardCharsets.UTF_8, markedCompleted, (Object)node);
    }

    private boolean couldBeComplete() {
        return this.timestampTracker.checkCompletion(timestamp -> {
            List events;
            try {
                events = this.client.filterLogEvents((FilterLogEventsRequest)this.createFilter().limit(Integer.valueOf(1)).startTime(timestamp).build()).events();
            }
            catch (ResourceNotFoundException e) {
                LOGGER.log(Level.FINE, "{0} or its stream {1}@* do not exist: {2}", new Object[]{this.logGroupName, this.logStreamNameBase, e.getMessage()});
                return false;
            }
            if (events.isEmpty()) {
                LOGGER.log(Level.FINE, "{0} contains no event in {1}@* with timestamp={2}", new Object[]{this.logGroupName, this.logStreamNameBase, timestamp});
                return false;
            }
            LOGGER.log(Level.FINER, "{0} does contain an event in {1}@* with timestamp={2}", new Object[]{this.logGroupName, this.logStreamNameBase, timestamp});
            return true;
        });
    }

    private void stream(OutputStream os, @CheckForNull String nodeId, @CheckForNull List<String> idsByLine) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            String token = null;
            do {
                FilterLogEventsResponse result;
                try {
                    result = this.client.filterLogEvents((FilterLogEventsRequest)this.createFilter().filterPattern("{$.build = \"" + this.buildId + (String)(nodeId == null ? "" : "\" && $.node = \"" + nodeId) + "\"}").nextToken(token).build());
                }
                catch (ResourceNotFoundException e) {
                    throw new IOException(String.format("Unable to find log group \"%s\" or log stream \"%s@*\"", this.logGroupName, this.logStreamNameBase), e);
                }
                token = result.nextToken();
                ArrayList<FilteredLogEvent> events = new ArrayList<FilteredLogEvent>(result.events());
                LOGGER.log(Level.FINER, "event count {0} from group={1} stream={2}@* buildId={3} nodeId={4}", new Object[]{events.size(), this.logGroupName, this.logStreamNameBase, this.buildId, nodeId});
                events.sort(Comparator.comparing(FilteredLogEvent::timestamp));
                for (FilteredLogEvent event : events) {
                    JSONObject json = JSONObject.fromObject((Object)event.message());
                    assert (this.buildId.equals(json.optString("build")));
                    ConsoleNotes.write(w, json);
                    if (idsByLine == null) continue;
                    idsByLine.add(json.optString("node", null));
                }
            } while (token != null);
            ((Writer)w).flush();
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
    }

    private FilterLogEventsRequest.Builder createFilter() {
        return FilterLogEventsRequest.builder().logGroupName(this.logGroupName).logStreamNamePrefix(this.logStreamNameBase + "@");
    }

    private class OverallLog
    extends AnnotatedLargeText<FlowExecutionOwner.Executable> {
        private final FlowExecutionOwner.Executable context;
        private final List<String> idsByLine;
        private final ByteBuffer buf;

        OverallLog(FlowExecutionOwner.Executable build, boolean completed) throws IOException {
            this(new ByteBuffer(), completed, build);
        }

        private OverallLog(ByteBuffer buf, boolean completed, FlowExecutionOwner.Executable context) throws IOException {
            super(buf, StandardCharsets.UTF_8, completed && CloudWatchRetriever.this.couldBeComplete(), (Object)context);
            this.idsByLine = new ArrayList<String>();
            this.context = context;
            CloudWatchRetriever.this.stream((OutputStream)buf, null, this.idsByLine);
            this.buf = buf;
        }

        public long writeHtmlTo(long start, final Writer w) throws IOException {
            if (start == 0L && !Main.isUnitTest) {
                String url = "https://console.aws.amazon.com/cloudwatch/home#logEventViewer:group=" + CloudWatchRetriever.this.logGroupName + ";stream=" + CloudWatchRetriever.this.logStreamNameBase + "@master;filter=" + URLEncoder.encode(URLEncoder.encode("{$.build = \"" + CloudWatchRetriever.this.buildId + "\"}", "UTF-8").replace("+", "%20"), "UTF-8");
                w.write("[view in <a href=\"" + url + "\" target=\"_blank\">AWS Console</a>, if authorized, plus related streams for agent output]\n");
            }
            final AtomicInteger line = new AtomicInteger();
            if (start > 0L) {
                try (InputStream is = this.buf.newInputStream();){
                    for (long remaining = start; remaining > 0L; --remaining) {
                        int c = is.read();
                        if (c == -1) {
                            LOGGER.log(Level.WARNING, "EOF while calculating line numbers from {0} with remaining {1}", new Object[]{start, remaining});
                            break;
                        }
                        if (c != 10) continue;
                        line.incrementAndGet();
                    }
                }
            }
            ConsoleAnnotationOutputStream<FlowExecutionOwner.Executable> caw = new ConsoleAnnotationOutputStream<FlowExecutionOwner.Executable>(w, ConsoleAnnotators.createAnnotator((Object)this.context), this.context, StandardCharsets.UTF_8){
                private String currentId;

                protected void eol(byte[] in, int sz) throws IOException {
                    String id = OverallLog.this.idsByLine.get(line.getAndIncrement());
                    if (id != null) {
                        if (!id.equals(this.currentId)) {
                            if (this.currentId != null) {
                                w.write(LogStorage.endStep());
                            }
                            w.write(LogStorage.startStep((String)id));
                        }
                    } else if (this.currentId != null) {
                        w.write(LogStorage.endStep());
                    }
                    super.eol(in, sz);
                    this.currentId = id;
                }

                public void flush() throws IOException {
                    super.flush();
                    if (this.currentId != null) {
                        w.write(LogStorage.endStep());
                    }
                }
            };
            long r = this.writeRawLogTo(start, (OutputStream)caw);
            ConsoleAnnotators.setAnnotator((ConsoleAnnotator)caw.getConsoleAnnotator());
            return r;
        }
    }
}

