/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.ChildToolModel;
import io.jenkins.plugins.pipeline.models.ToolsModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ToolsParser
extends AbstractParser
implements ParserInterface<ToolsModel> {
    private LinkedHashMap toolsNode;
    private LinkedHashMap parentNode;

    public ToolsParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "tools";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<ToolsModel> parse() {
        try {
            ArrayList<ChildToolModel> childToolModels = new ArrayList<ChildToolModel>();
            this.toolsNode = this.getChildNodeAsLinkedHashMap(this.parentNode);
            if (this.toolsNode == null || this.toolsNode.size() == 0) {
                return Optional.empty();
            }
            Iterator iterator = this.toolsNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry childTool;
                Map.Entry childToolEntry = childTool = iterator.next();
                String childToolKey = (String)childToolEntry.getKey();
                String childToolValue = (String)childToolEntry.getValue();
                childToolModels.add(new ChildToolModel(childToolKey, childToolValue));
            }
            return Optional.of(new ToolsModel(childToolModels));
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

