/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.StepsModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import io.jenkins.plugins.pipeline.parsers.ScriptParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class StepsParser
extends AbstractParser
implements ParserInterface<StepsModel> {
    private LinkedHashMap parentNode;

    public StepsParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "steps";
        this.parentNode = parentNode;
    }

    public StepsParser(List stepsList) {
        this.yamlNodeName = "steps";
        LinkedHashMap<String, List> tempLinkedHashMap = new LinkedHashMap<String, List>();
        tempLinkedHashMap.put(this.yamlNodeName, stepsList);
        this.parentNode = tempLinkedHashMap;
    }

    @Override
    public Optional<StepsModel> parse() {
        try {
            Object stepsNode = this.getValue(this.parentNode, this.yamlNodeName);
            if (stepsNode instanceof LinkedHashMap) {
                return Optional.of(new StepsModel(new ScriptParser((LinkedHashMap)stepsNode).parse()));
            }
            if (stepsNode instanceof String) {
                return Optional.of(new StepsModel((String)stepsNode));
            }
            return Optional.of(new StepsModel((List)stepsNode));
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

