/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlUnknownTypeException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.StageModel;
import io.jenkins.plugins.pipeline.models.StagesModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import io.jenkins.plugins.pipeline.parsers.StageParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class StagesParser
extends AbstractParser
implements ParserInterface<StagesModel> {
    private LinkedHashMap parentNode;

    public StagesParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "stages";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<StagesModel> parse() {
        try {
            ArrayList<StageModel> stageModelList = new ArrayList<StageModel>();
            Object stagesObject = this.getChildNodeAsObject(this.parentNode);
            if (stagesObject == null) {
                return Optional.empty();
            }
            if (stagesObject instanceof List) {
                for (LinkedHashMap childStage : (List)stagesObject) {
                    Optional<StageModel> stageModel = new StageParser(childStage).parse();
                    stageModel.ifPresent(stageModelList::add);
                }
                return Optional.of(new StagesModel(stageModelList));
            }
            throw new PipelineAsYamlUnknownTypeException(stagesObject.getClass().toString());
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

