/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlUnknownTypeException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.ScriptModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import io.jenkins.plugins.pipeline.parsers.SubScriptParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class ScriptParser
extends AbstractParser
implements ParserInterface<ScriptModel> {
    private LinkedHashMap parentNode;

    public ScriptParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "script";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<ScriptModel> parse() {
        try {
            Object scripts = this.getChildNodeAsObject(this.parentNode);
            if (scripts instanceof List) {
                ArrayList scriptModelList = new ArrayList();
                for (Object element : (List)scripts) {
                    if (element instanceof String) {
                        scriptModelList.add(element);
                        continue;
                    }
                    if (!(element instanceof LinkedHashMap)) continue;
                    scriptModelList.add(new SubScriptParser((LinkedHashMap)element).parse());
                }
                return Optional.of(new ScriptModel(scriptModelList));
            }
            if (scripts instanceof String) {
                return Optional.of(new ScriptModel((String)scripts));
            }
            throw new PipelineAsYamlUnknownTypeException(scripts.getClass().getName());
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

