/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.ChildPostModel;
import io.jenkins.plugins.pipeline.models.PostModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import io.jenkins.plugins.pipeline.parsers.ScriptParser;
import io.jenkins.plugins.pipeline.parsers.StepsParser;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PostParser
extends AbstractParser
implements ParserInterface<PostModel> {
    private LinkedHashMap postNode;
    private LinkedHashMap parentNode;

    public PostParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "post";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<PostModel> parse() {
        try {
            ArrayList<ChildPostModel> childPostModels = new ArrayList<ChildPostModel>();
            this.postNode = this.getChildNodeAsLinkedHashMap(this.parentNode);
            if (this.postNode == null || this.postNode.size() == 0) {
                return Optional.empty();
            }
            for (Map.Entry childPost : this.postNode.entrySet()) {
                Map.Entry childPostNode = childPost;
                String childPostKey = (String)childPostNode.getKey();
                Object postSubNode = this.postNode.get(childPostKey);
                if (postSubNode instanceof LinkedHashMap) {
                    childPostModels.add(new ChildPostModel(childPostKey, Optional.empty(), new ScriptParser((LinkedHashMap)postSubNode).parse()));
                    continue;
                }
                if (!(postSubNode instanceof List)) continue;
                childPostModels.add(new ChildPostModel(childPostKey, new StepsParser((List)postSubNode).parse(), Optional.empty()));
            }
            return Optional.of(new PostModel(childPostModels));
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

