/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlKeyEmptyException;
import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlNodeNotFoundException;
import io.jenkins.plugins.pipeline.models.EnvironmentVariableModel;
import io.jenkins.plugins.pipeline.models.KeyValueModel;
import io.jenkins.plugins.pipeline.models.VariableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public abstract class AbstractParser {
    protected String yamlNodeName = "";
    protected Yaml yaml;

    public AbstractParser() {
        Representer representer = new Representer(new DumperOptions());
        representer.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), representer);
    }

    protected Object getValue(LinkedHashMap parentNode, String key) throws PipelineAsYamlKeyEmptyException {
        if (parentNode.containsKey(key)) {
            return parentNode.get(key);
        }
        throw new PipelineAsYamlKeyEmptyException();
    }

    protected LinkedHashMap getChildNodeAsLinkedHashMap(LinkedHashMap parentNode) throws PipelineAsYamlNodeNotFoundException {
        LinkedHashMap childNode = (LinkedHashMap)parentNode.get(this.yamlNodeName);
        if (childNode == null) {
            throw new PipelineAsYamlNodeNotFoundException(this.yamlNodeName);
        }
        return childNode;
    }

    protected List getChildNodeAsList(LinkedHashMap parentNode) throws PipelineAsYamlNodeNotFoundException {
        List childNode = (List)parentNode.get(this.yamlNodeName);
        if (childNode == null) {
            throw new PipelineAsYamlNodeNotFoundException(this.yamlNodeName);
        }
        return childNode;
    }

    protected String getChildNodeAsString(LinkedHashMap parentNode) throws PipelineAsYamlNodeNotFoundException {
        String childNode = (String)parentNode.get(this.yamlNodeName);
        if (childNode == null) {
            throw new PipelineAsYamlNodeNotFoundException(this.yamlNodeName);
        }
        return childNode;
    }

    protected Object getChildNodeAsObject(LinkedHashMap parentNode) throws PipelineAsYamlNodeNotFoundException {
        Object childNode = parentNode.get(this.yamlNodeName);
        if (childNode == null) {
            throw new PipelineAsYamlNodeNotFoundException(this.yamlNodeName);
        }
        return childNode;
    }

    protected String getKey(LinkedHashMap node) throws PipelineAsYamlKeyEmptyException {
        Set set = node.keySet();
        Optional key = set.stream().findFirst();
        if (!key.isPresent()) {
            throw new PipelineAsYamlKeyEmptyException();
        }
        return (String)key.get();
    }

    protected List<KeyValueModel> extractParameters(Object parameter) {
        ArrayList<KeyValueModel> extractedParameters = new ArrayList<KeyValueModel>();
        if (parameter == null) {
            return new ArrayList<KeyValueModel>();
        }
        if (parameter instanceof LinkedHashMap) {
            LinkedHashMap agentParameters = (LinkedHashMap)parameter;
            Iterator iterator = agentParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entryMap = entry = iterator.next();
                KeyValueModel keyValueModel = new KeyValueModel((String)entryMap.getKey(), (String)entryMap.getValue());
                extractedParameters.add(keyValueModel);
            }
            return extractedParameters;
        }
        if (parameter instanceof String) {
            KeyValueModel keyValueModel = new KeyValueModel("label", (String)parameter);
            extractedParameters.add(keyValueModel);
        }
        return extractedParameters;
    }

    protected List<VariableModel> convertVariableModel(List<KeyValueModel> keyValueModels) {
        ArrayList<VariableModel> variableModelList = new ArrayList<VariableModel>();
        keyValueModels.forEach(keyValueModel -> variableModelList.add(new VariableModel(keyValueModel.getKey(), keyValueModel.getValue())));
        return variableModelList;
    }

    protected List<EnvironmentVariableModel> convertEnvironmentVariableModel(List<KeyValueModel> keyValueModels) {
        ArrayList<EnvironmentVariableModel> variableModelList = new ArrayList<EnvironmentVariableModel>();
        keyValueModels.forEach(keyValueModel -> variableModelList.add(new EnvironmentVariableModel(keyValueModel.getKey(), keyValueModel.getValue())));
        return variableModelList;
    }

    @Generated
    public String getYamlNodeName() {
        return this.yamlNodeName;
    }

    @Generated
    public Yaml getYaml() {
        return this.yaml;
    }

    @Generated
    public void setYamlNodeName(String yamlNodeName) {
        this.yamlNodeName = yamlNodeName;
    }

    @Generated
    public void setYaml(Yaml yaml) {
        this.yaml = yaml;
    }
}

