/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.models;

import io.jenkins.plugins.pipeline.interfaces.ParsableModelInterface;
import io.jenkins.plugins.pipeline.models.AbstractModel;
import io.jenkins.plugins.pipeline.models.AgentModel;
import io.jenkins.plugins.pipeline.models.EnvironmentModel;
import io.jenkins.plugins.pipeline.models.LibraryModel;
import io.jenkins.plugins.pipeline.models.OptionsModel;
import io.jenkins.plugins.pipeline.models.ParametersModel;
import io.jenkins.plugins.pipeline.models.PostModel;
import io.jenkins.plugins.pipeline.models.StagesModel;
import io.jenkins.plugins.pipeline.models.ToolsModel;
import io.jenkins.plugins.pipeline.models.TriggersModel;
import java.util.Optional;
import lombok.Generated;
import org.apache.ivy.util.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.Converter;

public class PipelineModel
extends AbstractModel
implements ParsableModelInterface {
    public static final String directive = "pipeline";
    private Optional<AgentModel> agent;
    private Optional<PostModel> post;
    private Optional<EnvironmentModel> environment;
    private Optional<ToolsModel> tools;
    private Optional<OptionsModel> options;
    private Optional<ParametersModel> parameters;
    private Optional<TriggersModel> triggers;
    private Optional<StagesModel> stages;
    private Optional<LibraryModel> library;

    @Override
    public String toGroovy() {
        return new StringBuffer().append(this.library.map(LibraryModel::toGroovy).orElse("")).append(directive).append(this.getDirectiveOpen()).append(this.agent.map(AgentModel::toGroovy).orElse("")).append(this.tools.map(ToolsModel::toGroovy).orElse("")).append(this.environment.map(EnvironmentModel::toGroovy).orElse("")).append(this.options.map(OptionsModel::toGroovy).orElse("")).append(this.parameters.map(ParametersModel::toGroovy).orElse("")).append(this.triggers.map(TriggersModel::toGroovy).orElse("")).append(this.stages.map(StagesModel::toGroovy).orElse("")).append(this.post.map(PostModel::toGroovy).orElse("")).append(this.getDirectiveClose()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toPrettyGroovy() {
        StringBuffer prettyGroovyString = new StringBuffer();
        String groovyString = this.toGroovy();
        String[] parsedString = groovyString.split("\n");
        int indentCounter = 0;
        for (String string : parsedString) {
            void var8_13;
            if (string.length() == 0) continue;
            if (string.endsWith("{")) {
                String string2 = this.indent(indentCounter) + string + "\n";
                ++indentCounter;
            } else if (string.startsWith("}")) {
                String string3 = this.indent(--indentCounter) + string + "\n";
            } else {
                String string4 = this.indent(indentCounter) + string + "\n";
            }
            prettyGroovyString.append((String)var8_13);
        }
        return prettyGroovyString.toString();
    }

    private String indent(int count) {
        return StringUtils.repeat((String)"  ", (int)Math.max(count, 0));
    }

    public ModelASTPipelineDef validate() {
        String pipelineString = this.toPrettyGroovy();
        return Converter.scriptToPipelineDef((String)pipelineString);
    }

    @Generated
    PipelineModel(Optional<AgentModel> agent, Optional<PostModel> post, Optional<EnvironmentModel> environment, Optional<ToolsModel> tools, Optional<OptionsModel> options, Optional<ParametersModel> parameters, Optional<TriggersModel> triggers, Optional<StagesModel> stages, Optional<LibraryModel> library) {
        this.agent = agent;
        this.post = post;
        this.environment = environment;
        this.tools = tools;
        this.options = options;
        this.parameters = parameters;
        this.triggers = triggers;
        this.stages = stages;
        this.library = library;
    }

    @Generated
    public static PipelineModelBuilder builder() {
        return new PipelineModelBuilder();
    }

    @Generated
    public Optional<AgentModel> getAgent() {
        return this.agent;
    }

    @Generated
    public Optional<PostModel> getPost() {
        return this.post;
    }

    @Generated
    public Optional<EnvironmentModel> getEnvironment() {
        return this.environment;
    }

    @Generated
    public Optional<ToolsModel> getTools() {
        return this.tools;
    }

    @Generated
    public Optional<OptionsModel> getOptions() {
        return this.options;
    }

    @Generated
    public Optional<ParametersModel> getParameters() {
        return this.parameters;
    }

    @Generated
    public Optional<TriggersModel> getTriggers() {
        return this.triggers;
    }

    @Generated
    public Optional<StagesModel> getStages() {
        return this.stages;
    }

    @Generated
    public Optional<LibraryModel> getLibrary() {
        return this.library;
    }

    @Generated
    public static class PipelineModelBuilder {
        @Generated
        private Optional<AgentModel> agent;
        @Generated
        private Optional<PostModel> post;
        @Generated
        private Optional<EnvironmentModel> environment;
        @Generated
        private Optional<ToolsModel> tools;
        @Generated
        private Optional<OptionsModel> options;
        @Generated
        private Optional<ParametersModel> parameters;
        @Generated
        private Optional<TriggersModel> triggers;
        @Generated
        private Optional<StagesModel> stages;
        @Generated
        private Optional<LibraryModel> library;

        @Generated
        PipelineModelBuilder() {
        }

        @Generated
        public PipelineModelBuilder agent(Optional<AgentModel> agent) {
            this.agent = agent;
            return this;
        }

        @Generated
        public PipelineModelBuilder post(Optional<PostModel> post) {
            this.post = post;
            return this;
        }

        @Generated
        public PipelineModelBuilder environment(Optional<EnvironmentModel> environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public PipelineModelBuilder tools(Optional<ToolsModel> tools) {
            this.tools = tools;
            return this;
        }

        @Generated
        public PipelineModelBuilder options(Optional<OptionsModel> options) {
            this.options = options;
            return this;
        }

        @Generated
        public PipelineModelBuilder parameters(Optional<ParametersModel> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public PipelineModelBuilder triggers(Optional<TriggersModel> triggers) {
            this.triggers = triggers;
            return this;
        }

        @Generated
        public PipelineModelBuilder stages(Optional<StagesModel> stages) {
            this.stages = stages;
            return this;
        }

        @Generated
        public PipelineModelBuilder library(Optional<LibraryModel> library) {
            this.library = library;
            return this;
        }

        @Generated
        public PipelineModel build() {
            return new PipelineModel(this.agent, this.post, this.environment, this.tools, this.options, this.parameters, this.triggers, this.stages, this.library);
        }

        @Generated
        public String toString() {
            return "PipelineModel.PipelineModelBuilder(agent=" + String.valueOf(this.agent) + ", post=" + String.valueOf(this.post) + ", environment=" + String.valueOf(this.environment) + ", tools=" + String.valueOf(this.tools) + ", options=" + String.valueOf(this.options) + ", parameters=" + String.valueOf(this.parameters) + ", triggers=" + String.valueOf(this.triggers) + ", stages=" + String.valueOf(this.stages) + ", library=" + String.valueOf(this.library) + ")";
        }
    }
}

