/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.models;

import io.jenkins.plugins.pipeline.interfaces.ParsableModelInterface;
import io.jenkins.plugins.pipeline.models.AbstractModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.ivy.util.StringUtils;

public class LibraryModel
extends AbstractModel
implements ParsableModelInterface {
    public static final String directive = "library";
    private List<String> libraryList;

    public LibraryModel(List<String> libraryList) {
        this.libraryList = this.setLibrarySyntax(libraryList);
    }

    public LibraryModel(String libraryDefinition) {
        this.libraryList = this.setLibrarySyntax(Arrays.asList(libraryDefinition));
    }

    private List<String> setLibrarySyntax(List<String> libraryList) {
        ArrayList<String> convertedList = new ArrayList<String>();
        libraryList.forEach(s -> {
            s = "'" + (String)s + "'";
            convertedList.add((String)s);
        });
        return convertedList;
    }

    @Override
    public String toGroovy() {
        StringBuffer groovyString = new StringBuffer().append(this.getLibraryOpen());
        if (this.libraryList.size() == 1) {
            groovyString.append(StringUtils.joinArray((String[])this.libraryList.toArray(new String[this.libraryList.size()]), (String)","));
        } else {
            groovyString.append("[");
            groovyString.append(StringUtils.joinArray((String[])this.libraryList.toArray(new String[this.libraryList.size()]), (String)","));
            groovyString.append("]");
        }
        groovyString.append(this.getLibraryClose());
        return groovyString.toString();
    }

    @Generated
    public List<String> getLibraryList() {
        return this.libraryList;
    }
}

