/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.models;

import io.jenkins.plugins.pipeline.interfaces.ParsableModelInterface;
import io.jenkins.plugins.pipeline.models.AbstractModel;
import io.jenkins.plugins.pipeline.models.KeyValueModel;
import java.util.List;
import lombok.Generated;

public class AgentModel
extends AbstractModel
implements ParsableModelInterface {
    public static final String directive = "agent";
    private String agentType;
    private List<KeyValueModel> agentParameter;

    public AgentModel(String agentType, List<KeyValueModel> agentParameter) {
        this.agentType = this.convertAgentType(agentType);
        this.agentParameter = agentParameter;
    }

    private String convertAgentType(String agentType) {
        if (agentType.equals("label")) {
            return "node";
        }
        return agentType;
    }

    @Override
    public String toGroovy() {
        StringBuffer groovyString = new StringBuffer().append(directive);
        if (!this.agentType.equals("none") && !this.agentType.equals("any")) {
            groovyString.append(this.getDirectiveOpen());
        } else {
            groovyString.append(" ");
        }
        groovyString.append(this.agentType);
        if (this.agentParameter.size() > 0) {
            groovyString.append(this.getDirectiveOpen());
            if (this.agentType.equals("kubernetes")) {
                for (KeyValueModel keyValueModel2 : this.agentParameter) {
                    if (keyValueModel2.getKey().equals("yaml")) {
                        groovyString.append(keyValueModel2.getKey()).append(" \"\"\"\n").append(keyValueModel2.getValue()).append("\n\"\"\"\n");
                        continue;
                    }
                    groovyString.append(keyValueModel2.toGroovy());
                }
            } else {
                this.agentParameter.forEach(keyValueModel -> groovyString.append(keyValueModel.toGroovy()));
            }
            groovyString.append(this.getDirectiveClose());
        }
        if (!this.agentType.equals("none") && !this.agentType.equals("any")) {
            groovyString.append(this.getDirectiveClose());
        } else {
            groovyString.append("\n");
        }
        return groovyString.toString();
    }

    @Generated
    public String getAgentType() {
        return this.agentType;
    }

    @Generated
    public List<KeyValueModel> getAgentParameter() {
        return this.agentParameter;
    }
}

