/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.pipeline.Messages;
import io.jenkins.plugins.pipeline.scm.ExtendedSCMBinder;
import io.jenkins.plugins.pipeline.scm.SCMSourceCriteriaForYamlFile;
import java.io.Serializable;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.multibranch.AbstractWorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PipelineAsYamlWorkflowBranchProjectFactory
extends WorkflowBranchProjectFactory {
    private String yamlJenkinsFile = "Jenkinsfile.yaml";

    @DataBoundConstructor
    public PipelineAsYamlWorkflowBranchProjectFactory(String yamlJenkinsFile) {
        this.yamlJenkinsFile = yamlJenkinsFile;
    }

    public String getYamlJenkinsFile() {
        return this.yamlJenkinsFile;
    }

    @DataBoundSetter
    public void setYamlJenkinsFile(String yamlJenkinsFile) {
        this.yamlJenkinsFile = yamlJenkinsFile;
    }

    protected FlowDefinition createDefinition() {
        return new ExtendedSCMBinder(this.getYamlJenkinsFile());
    }

    protected SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        return (SCMSourceCriteria & Serializable)(probe, taskListener) -> SCMSourceCriteriaForYamlFile.matches(this.getYamlJenkinsFile(), probe, taskListener);
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run> {
        public void onInitialize(Run run) {
            super.onInitialize(run);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractWorkflowBranchProjectFactory.AbstractWorkflowBranchProjectFactoryDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.ProjectRecognizer_DisplayName();
        }
    }
}

