/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.scm;

import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMSourceCriteria;

public class SCMSourceCriteriaForYamlFile {
    public static boolean matches(String localFile, SCMSourceCriteria.Probe probe, TaskListener taskListener) throws IOException {
        SCMProbeStat stat = probe.stat(localFile);
        switch (stat.getType()) {
            case NONEXISTENT: {
                if (stat.getAlternativePath() != null) {
                    taskListener.getLogger().format("      \u2018%s\u2019 not found (but found \u2018%s\u2019, search is case sensitive)%n", localFile, stat.getAlternativePath());
                } else {
                    taskListener.getLogger().format("      \u2018%s\u2019 not found%n", localFile);
                }
                return false;
            }
            case DIRECTORY: {
                taskListener.getLogger().format("      \u2018%s\u2019 found but is a directory not a file%n", localFile);
                return false;
            }
        }
        taskListener.getLogger().format("      \u2018%s\u2019 found%n", localFile);
        return true;
    }
}

