/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline.parsers;

import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlException;
import io.jenkins.plugins.pipeline.exceptions.PipelineAsYamlUnknownTypeException;
import io.jenkins.plugins.pipeline.interfaces.ParserInterface;
import io.jenkins.plugins.pipeline.models.WhenModel;
import io.jenkins.plugins.pipeline.parsers.AbstractParser;
import io.jenkins.plugins.pipeline.parsers.WhenConditionalParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

public class WhenParser
extends AbstractParser
implements ParserInterface<WhenModel> {
    private LinkedHashMap parentNode;

    public WhenParser(LinkedHashMap parentNode) {
        this.yamlNodeName = "when";
        this.parentNode = parentNode;
    }

    @Override
    public Optional<WhenModel> parse() {
        try {
            Object whenObject = this.getValue(this.parentNode, this.yamlNodeName);
            if (whenObject instanceof List) {
                return Optional.of(new WhenModel((List)whenObject));
            }
            if (whenObject instanceof LinkedHashMap) {
                return Optional.of(new WhenModel(new WhenConditionalParser((LinkedHashMap)whenObject).parse()));
            }
            throw new PipelineAsYamlUnknownTypeException(whenObject.getClass().toString());
        }
        catch (PipelineAsYamlException p) {
            return Optional.empty();
        }
    }
}

